/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.xslt;

import javax.xml.transform.Transformer;
import org.springframework.util.Assert;

public abstract class TransformerUtils {
    public static final int DEFAULT_INDENT_AMOUNT = 2;

    public static void enableIndenting(Transformer transformer) {
        TransformerUtils.enableIndenting(transformer, 2);
    }

    public static void enableIndenting(Transformer transformer, int indentAmount) {
        Assert.notNull(transformer);
        Assert.isTrue(indentAmount > -1, "The indent amount cannot be less than zero : got " + indentAmount);
        transformer.setOutputProperty("indent", "yes");
        try {
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(indentAmount));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static void disableIndenting(Transformer transformer) {
        Assert.notNull(transformer);
        transformer.setOutputProperty("indent", "no");
    }
}

