/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2;

import gr.forth.ics.swkm.model2.Model;
import gr.forth.ics.swkm.model2.ObjectNodeImpl;
import gr.forth.ics.swkm.model2.RdfNode;
import gr.forth.ics.swkm.model2.RdfNodeImpl;
import gr.forth.ics.swkm.model2.RdfType;
import gr.forth.ics.swkm.model2.Resource;
import gr.forth.ics.swkm.model2.ResourceImpl;
import gr.forth.ics.swkm.model2.Triple;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TripleImpl
implements Triple {
    private final ObjectNodeImpl subject;
    private final ResourceImpl predicate;
    private final RdfNodeImpl object;
    Set<ResourceImpl> namedGraphs = Collections.emptySet();
    private short cachedSpoType;
    private static final RdfType[] rdfTypes = RdfType.values();

    TripleImpl(ObjectNodeImpl subject, ResourceImpl predicate, RdfNodeImpl object) {
        Assert.notNull((Object)subject, (String)"subject");
        Assert.notNull((Object)predicate, (String)"predicate");
        Assert.notNull((Object)object, (String)"object");
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
    }

    @Override
    public Collection<Resource> graphs() {
        return Collections.unmodifiableCollection(this.namedGraphs);
    }

    @Override
    public Model owner() {
        return this.subject.owner();
    }

    @Override
    public ObjectNodeImpl subject() {
        return this.subject;
    }

    @Override
    public ResourceImpl predicate() {
        return this.predicate;
    }

    @Override
    public RdfNodeImpl object() {
        return this.object;
    }

    public int hashCode() {
        return 7 + 29791 * this.subject.hashCode() + 961 * this.predicate.hashCode() + 31 * this.object.hashCode() + this.owner().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TripleImpl)) {
            return false;
        }
        TripleImpl other = (TripleImpl)obj;
        return this.object == other.object && this.subject == other.subject && this.predicate == other.predicate && this.owner() == other.owner();
    }

    public String toString() {
        return "[<" + this.subject + " " + this.predicate + " " + this.object + "> {" + this.namedGraphs + "}]";
    }

    @Override
    public String toSimpleString() {
        return "<" + this.subject + " " + this.predicate + " " + this.object + ">";
    }

    String toStringWithTypes() {
        return String.format("[<%s>(%s) <%s> <%s>(%s) {%s}]", new Object[]{this.subject, this.subject.type(), this.predicate, this.object, this.object.type(), this.namedGraphs});
    }

    ObjectNodeImpl getObjectResource() {
        RdfNodeImpl obj = this.object();
        if (!obj.isObjectNode()) {
            throw new IllegalStateException("In triple: " + this + ", object is not a resource");
        }
        return (ObjectNodeImpl)obj;
    }

    void inferTypesOfParts() {
        RdfType subjectType = this.subject().type();
        RdfType predicateType = this.predicate().type();
        RdfType objectType = this.object().type();
        if (subjectType == this.cachedSubjectType() && predicateType == this.cachedPredicateType() && objectType == this.cachedObjectType()) {
            return;
        }
        this.predicate.feedPredicateTriple(this);
        this.cachedSpoType = this.getSpoType();
    }

    private RdfType cachedSubjectType() {
        return rdfTypes[this.cachedSpoType & 0xF];
    }

    private RdfType cachedPredicateType() {
        return rdfTypes[this.cachedSpoType >> 4 & 0xF];
    }

    private RdfType cachedObjectType() {
        return rdfTypes[this.cachedSpoType >> 8 & 0xF];
    }

    private short getSpoType() {
        return (short)(this.subject.type().ordinal() | this.predicate.type().ordinal() << 4 | this.object.type().ordinal() << 8);
    }

    public Iterable<ObjectNodeImpl> nonLiterals() {
        if (this.object.isResource()) {
            return Arrays.asList(this.subject, this.predicate, this.getObjectResource());
        }
        return Arrays.asList(this.subject, this.predicate);
    }

    @Override
    public Iterable<RdfNode> nodes() {
        return Arrays.asList(this.subject, this.predicate, this.object);
    }

    @Override
    public boolean delete() {
        return this.owner().delete(this);
    }
}

