/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2.importer;

import com.google.common.collect.Maps;
import gr.forth.ics.swkm.model2.Uri;
import gr.forth.ics.swkm.vocabulary.Rdf;
import gr.forth.ics.swkm.vocabulary.RdfSchema;
import gr.forth.ics.swkm.vocabulary.RdfSuite;
import gr.forth.ics.swkm.vocabulary.XmlSchema;
import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DbConstants {
    private static final Map<Uri, Integer> ids = Maps.newHashMap();
    private static final Map<Uri, Integer> postOrders = Maps.newHashMap();
    private static final Map<Uri, String> tableNames = Maps.newHashMap();
    private static final Map<Uri, Integer> rqlKinds = Maps.newHashMap();
    public static final int MAX_INT = 2000000000;
    public static final int INIT_POST_ORDER = 300;

    static Map<Uri, Integer> getRqlIds() {
        return Collections.unmodifiableMap(ids);
    }

    private DbConstants() {
    }

    public static int getIdFor(Uri uri) {
        return DbConstants.get(ids, uri, "id");
    }

    public static int getPostOrderFor(Uri uri) {
        return DbConstants.get(postOrders, uri, "postOrder");
    }

    public static int getRqlKindFor(Uri uri) {
        return DbConstants.get(rqlKinds, uri, "rqlId");
    }

    public static String getNameFor(Uri uri) {
        return DbConstants.get(tableNames, uri, "table name");
    }

    private static <V> V get(Map<Uri, V> map, Uri uri, String type) {
        V value = map.get(uri);
        if (value == null) {
            throw new NoSuchElementException("No " + type + " for uri: '" + uri + "'");
        }
        return value;
    }

    static {
        ids.put(RdfSchema.CLASS, 1000000000);
        ids.put(RdfSuite.DATA_PROPERTY, 35);
        ids.put(Rdf.PROPERTY, 2000000000);
        ids.put(RdfSchema.RESOURCE, 2000000000);
        ids.put(RdfSuite.GRAPH, 77);
        ids.put(RdfSuite.THESAURUS, 36);
        ids.put(RdfSuite.ENUMERATION, 37);
        ids.put(RdfSchema.LITERAL, 12);
        ids.put(XmlSchema.STRING, 30);
        ids.put(XmlSchema.BOOLEAN, 33);
        ids.put(XmlSchema.INTEGER, 31);
        ids.put(XmlSchema.FLOAT, 32);
        ids.put(XmlSchema.DATETIME, 34);
        ids.put(XmlSchema.DECIMAL, 38);
        ids.put(XmlSchema.DOUBLE, 39);
        ids.put(XmlSchema.DURATION, 40);
        ids.put(XmlSchema.TIME, 41);
        ids.put(XmlSchema.DATE, 42);
        ids.put(XmlSchema.GYEAR_MONTH, 43);
        ids.put(XmlSchema.GYEAR, 44);
        ids.put(XmlSchema.GMONTH_DAY, 45);
        ids.put(XmlSchema.GDAY, 46);
        ids.put(XmlSchema.GMONTH, 47);
        ids.put(XmlSchema.HEX_BINARY, 48);
        ids.put(XmlSchema.BASE64_BINARY, 49);
        ids.put(XmlSchema.ANY_URI, 50);
        ids.put(XmlSchema.QNAME, 51);
        ids.put(XmlSchema.NOTATION, 52);
        ids.put(XmlSchema.NORMALIZED_STRING, 53);
        ids.put(XmlSchema.TOKEN, 54);
        ids.put(XmlSchema.LANGUAGE, 55);
        ids.put(XmlSchema.NMTOKEN, 56);
        ids.put(XmlSchema.NMTOKENS, 57);
        ids.put(XmlSchema.NAME, 58);
        ids.put(XmlSchema.NCNAME, 59);
        ids.put(XmlSchema.ID, 60);
        ids.put(XmlSchema.IDREF, 61);
        ids.put(XmlSchema.IDREFS, 62);
        ids.put(XmlSchema.ENTITY, 63);
        ids.put(XmlSchema.ENTITIES, 64);
        ids.put(XmlSchema.NON_POSITIVE_INTEGER, 65);
        ids.put(XmlSchema.NEGATIVE_INTEGER, 66);
        ids.put(XmlSchema.LONG, 67);
        ids.put(XmlSchema.INT, 68);
        ids.put(XmlSchema.SHORT, 69);
        ids.put(XmlSchema.BYTE, 70);
        ids.put(XmlSchema.NON_NEGATIVE_INTEGER, 71);
        ids.put(XmlSchema.UNSIGNED_LONG, 72);
        ids.put(XmlSchema.UNSIGNED_INT, 73);
        ids.put(XmlSchema.UNSIGNED_SHORT, 74);
        ids.put(XmlSchema.UNSIGNED_BYTE, 75);
        ids.put(XmlSchema.POSITIVE_INTEGER, 76);
        for (Uri uri : ids.keySet()) {
            postOrders.put(uri, 0);
        }
        postOrders.put(RdfSchema.CLASS, 300);
        postOrders.put(Rdf.PROPERTY, 1000000001);
        postOrders.put(RdfSchema.RESOURCE, 300);
        rqlKinds.put(RdfSchema.CLASS, 2);
        rqlKinds.put(Rdf.PROPERTY, 3);
        rqlKinds.put(RdfSuite.DATA_PROPERTY, 3);
        rqlKinds.put(RdfSchema.RESOURCE, 7);
        rqlKinds.put(RdfSchema.LITERAL, 8);
        rqlKinds.put(XmlSchema.STRING, 9);
        rqlKinds.put(XmlSchema.INTEGER, 11);
        rqlKinds.put(XmlSchema.BOOLEAN, 12);
        rqlKinds.put(RdfSuite.METACLASS, 13);
        rqlKinds.put(XmlSchema.DATETIME, 20);
        rqlKinds.put(XmlSchema.FLOAT, 21);
        rqlKinds.put(RdfSuite.THESAURUS, 22);
        rqlKinds.put(RdfSuite.ENUMERATION, 27);
        rqlKinds.put(XmlSchema.INT, 31);
        rqlKinds.put(XmlSchema.DECIMAL, 38);
        rqlKinds.put(XmlSchema.DOUBLE, 39);
        rqlKinds.put(XmlSchema.DURATION, 40);
        rqlKinds.put(XmlSchema.TIME, 41);
        rqlKinds.put(XmlSchema.DATE, 42);
        rqlKinds.put(XmlSchema.GYEAR_MONTH, 43);
        rqlKinds.put(XmlSchema.GYEAR, 44);
        rqlKinds.put(XmlSchema.GMONTH_DAY, 45);
        rqlKinds.put(XmlSchema.GDAY, 46);
        rqlKinds.put(XmlSchema.GMONTH, 47);
        rqlKinds.put(XmlSchema.HEX_BINARY, 48);
        rqlKinds.put(XmlSchema.BASE64_BINARY, 49);
        rqlKinds.put(XmlSchema.ANY_URI, 50);
        rqlKinds.put(XmlSchema.QNAME, 51);
        rqlKinds.put(XmlSchema.NOTATION, 52);
        rqlKinds.put(XmlSchema.NORMALIZED_STRING, 53);
        rqlKinds.put(XmlSchema.TOKEN, 54);
        rqlKinds.put(XmlSchema.LANGUAGE, 55);
        rqlKinds.put(XmlSchema.NMTOKEN, 56);
        rqlKinds.put(XmlSchema.NMTOKENS, 57);
        rqlKinds.put(XmlSchema.NAME, 58);
        rqlKinds.put(XmlSchema.NCNAME, 59);
        rqlKinds.put(XmlSchema.ID, 60);
        rqlKinds.put(XmlSchema.IDREF, 61);
        rqlKinds.put(XmlSchema.IDREFS, 62);
        rqlKinds.put(XmlSchema.ENTITY, 63);
        rqlKinds.put(XmlSchema.ENTITIES, 64);
        rqlKinds.put(XmlSchema.NON_POSITIVE_INTEGER, 65);
        rqlKinds.put(XmlSchema.NEGATIVE_INTEGER, 66);
        rqlKinds.put(XmlSchema.LONG, 67);
        rqlKinds.put(XmlSchema.SHORT, 69);
        rqlKinds.put(XmlSchema.BYTE, 70);
        rqlKinds.put(XmlSchema.NON_NEGATIVE_INTEGER, 71);
        rqlKinds.put(XmlSchema.UNSIGNED_LONG, 72);
        rqlKinds.put(XmlSchema.UNSIGNED_INT, 73);
        rqlKinds.put(XmlSchema.UNSIGNED_SHORT, 74);
        rqlKinds.put(XmlSchema.UNSIGNED_BYTE, 75);
        rqlKinds.put(XmlSchema.POSITIVE_INTEGER, 76);
        rqlKinds.put(RdfSuite.GRAPH, 77);
        tableNames.put(RdfSchema.CLASS, "Class");
        tableNames.put(RdfSuite.DATA_PROPERTY, "DProperty");
        tableNames.put(Rdf.PROPERTY, "Property");
        tableNames.put(RdfSchema.LITERAL, "LiteralType");
        tableNames.put(RdfSuite.THESAURUS, "Thesaurus");
        tableNames.put(RdfSuite.ENUMERATION, "Enumeration");
    }
}

