/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2.importer;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import gr.forth.ics.swkm.model2.Model;
import gr.forth.ics.swkm.model2.RdfType;
import gr.forth.ics.swkm.model2.Resource;
import gr.forth.ics.swkm.model2.Uri;
import gr.forth.ics.swkm.model2.importer.DbConstants;
import gr.forth.ics.swkm.model2.importer.Jdbc;
import gr.forth.ics.swkm.model2.labels.Interval;
import gr.forth.ics.swkm.model2.labels.Label;
import gr.forth.ics.swkm.model2.labels.PredefinedLabels;
import gr.forth.ics.swkm.vocabulary.Rdf;
import gr.forth.ics.swkm.vocabulary.RdfSchema;
import gr.forth.ics.swkm.vocabulary.RdfSuite;
import gr.forth.ics.swkm.vocabulary.XmlSchema;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DbSynchronizer {
    private final Model model;
    private final Map<TypedId, StoredResource> storedResources;
    private final Map<Integer, StoredProperty> storedProperties;
    private final Map<Integer, Uri> virtualResources;

    private DbSynchronizer(Model model, Map<TypedId, StoredResource> storedResources, Map<Integer, StoredProperty> storedProperties, Map<Integer, Uri> virtualResources) {
        this.model = model;
        this.storedResources = storedResources;
        this.storedProperties = storedProperties;
        this.virtualResources = virtualResources;
    }

    PredefinedLabels synchronize(Uri sideEffectsNamedGraph) {
        Resource graph = this.model.mapResource(sideEffectsNamedGraph);
        Resource rdfType = this.model.mapResource(Rdf.TYPE);
        Resource rdfClass = this.model.mapResource(RdfSchema.CLASS);
        Resource rdfSubClassOf = this.model.mapResource(RdfSchema.SUBCLASSOF);
        Resource rdfDomain = this.model.mapResource(RdfSchema.DOMAIN);
        Resource rdfRange = this.model.mapResource(RdfSchema.RANGE);
        Resource rdfResource = this.model.mapResource(RdfSchema.RESOURCE);
        Resource rdfProperty = this.model.mapResource(Rdf.PROPERTY);
        HashMap labels = Maps.newHashMap();
        for (StoredResource resource : this.storedResources.values()) {
            Resource obj;
            switch (resource.type) {
                case CLASS: {
                    obj = rdfResource;
                    break;
                }
                case METACLASS: {
                    obj = rdfClass;
                    break;
                }
                case METAPROPERTY: {
                    obj = rdfProperty;
                    break;
                }
                default: {
                    throw new AssertionError((Object)resource.type);
                }
            }
            Resource subj = this.model.mapResource(resource.uri);
            if (subj == obj) continue;
            this.model.add(graph, subj, rdfSubClassOf, obj);
            labels.put(resource.uri, new Label(resource.interval));
        }
        for (StoredProperty property : this.storedProperties.values()) {
            Resource resource = this.model.mapResource(property.uri);
            this.model.add(graph, resource, rdfType, rdfProperty);
            this.model.add(graph, resource, rdfDomain, this.model.mapResource(this.storedResources.get((Object)property.domain).uri));
            if (this.virtualResources.containsKey(property.range.postId)) {
                this.model.add(graph, resource, rdfRange, this.model.mapResource(this.virtualResources.get(property.range.postId)));
            } else {
                this.model.add(graph, resource, rdfRange, this.model.mapResource(this.storedResources.get((Object)property.range).uri));
            }
            labels.put(property.uri, new Label(property.interval));
        }
        PredefinedLabels predefinedLabels = PredefinedLabels.fromUriMap(labels);
        return predefinedLabels;
    }

    static DbSynchronizer forModel(Model model) throws SQLException {
        ResultSet rs;
        HashSet resources = Sets.newHashSet();
        for (Resource r : model.resources()) {
            resources.add(r.getUri());
        }
        HashMap storedResources = Maps.newHashMap();
        HashMultimap namesBySpace = Multimaps.newHashMultimap();
        for (Uri uri : resources) {
            if (uri.hasEqualNamespace(Rdf.NAMESPACE) || uri.hasEqualNamespace(RdfSchema.NAMESPACE) || uri.hasEqualNamespace(XmlSchema.NAMESPACE) || uri.hasEqualNamespace(RdfSuite.NAMESPACE)) continue;
            namesBySpace.put((Object)uri.getNamespaceUri().toString(Uri.Hash.WITH), (Object)uri.getLocalName());
        }
        PreparedStatement classesOrMetatypes = Jdbc.prepared("SELECT DISTINCT c.att2, sc.att2, c.att0, 1 FROM t" + DbConstants.getIdFor(RdfSchema.CLASS) + " c, NAMESPACE ns, SUBCLASS sc " + "WHERE c.att2 = ANY(?) AND c.att1 = ns.att0 AND ns.att1 = ? AND c.att0 = sc.att0 " + "UNION ALL " + "SELECT DISTINCT mc.att2, smc.att2, mc.att0, 2 " + "FROM METACLASS mc, NAMESPACE ns, SUBMETACLASS smc " + "WHERE mc.att2 = ANY(?) AND mc.att1 = ns.att0 AND ns.att1 = ? AND smc.att0 = mc.att0 " + "UNION ALL " + "SELECT DISTINCT mc.att2, smp.att2, mc.att0, 3 " + "FROM METACLASS mc, NAMESPACE ns, SUBMETAPROPERTY smp " + "WHERE mc.att2 = ANY(?) AND mc.att1 = ns.att0 AND ns.att1 = ? AND smp.att0 = mc.att0", new Object[0]);
        for (String ns : namesBySpace.keySet()) {
            Collection localNames = namesBySpace.get((Object)ns);
            Array array = Jdbc.connection().createArrayOf("text", localNames.toArray());
            for (int i = 1; i < 6; i += 2) {
                classesOrMetatypes.setArray(i, array);
                classesOrMetatypes.setString(i + 1, ns);
            }
            rs = classesOrMetatypes.executeQuery();
            while (rs.next()) {
                RdfType type;
                String localName = rs.getString(1);
                int index = rs.getInt(2);
                int post = rs.getInt(3);
                switch (rs.getInt(4)) {
                    case 1: {
                        type = RdfType.CLASS;
                        break;
                    }
                    case 2: {
                        type = RdfType.METACLASS;
                        break;
                    }
                    case 3: {
                        type = RdfType.METAPROPERTY;
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                storedResources.put(new TypedId(type, post), new StoredResource(new Uri(ns, localName), new Interval(index, post), type));
                localNames.remove(localName);
            }
        }
        HashMap storedProperties = Maps.newHashMap();
        PreparedStatement properties = Jdbc.prepared("SELECT DISTINCT p.att2, sp.att2, p.att0, p.att3, p.att5, p.att4, p.att6 FROM t" + DbConstants.getIdFor(Rdf.PROPERTY) + " p, NAMESPACE ns, SUBPROPERTY sp " + "WHERE p.att2 = ANY(?) AND p.att1 = ns.att0 AND ns.att1 = ? AND p.att0 = sp.att0", new Object[0]);
        KindsAnalyzer kindsAnalyzer = new KindsAnalyzer(storedResources);
        for (String ns : namesBySpace.keySet()) {
            Collection localNames = namesBySpace.get((Object)ns);
            Array array = Jdbc.connection().createArrayOf("text", localNames.toArray());
            properties.setArray(1, array);
            properties.setString(2, ns);
            ResultSet rs2 = properties.executeQuery();
            while (rs2.next()) {
                String localName = rs2.getString(1);
                int index = rs2.getInt(2);
                int post = rs2.getInt(3);
                int domainId = rs2.getInt(4);
                int domainKind = rs2.getInt(5);
                int rangeId = rs2.getInt(6);
                int rangeKind = rs2.getInt(7);
                storedProperties.put(post, new StoredProperty(new Uri(ns, localName), new Interval(index, post), domainId, domainKind, rangeId, rangeKind));
                kindsAnalyzer.recordResourceIdAndKind(domainId, domainKind);
                kindsAnalyzer.recordResourceIdAndKind(rangeId, rangeKind);
            }
        }
        if (!kindsAnalyzer.getClassIds().isEmpty()) {
            PreparedStatement classesById = Jdbc.prepared("SELECT DISTINCT ns.att1, c.att2, sc.att2, c.att0 FROM t" + DbConstants.getIdFor(RdfSchema.CLASS) + " c, NAMESPACE ns, SUBCLASS sc " + "WHERE c.att1 = ns.att0 AND c.att0 = ANY(?) AND sc.att0 = c.att0", Jdbc.connection().createArrayOf("int", kindsAnalyzer.getClassIds().toArray()));
            rs = classesById.executeQuery();
            while (rs.next()) {
                String ns = rs.getString(1);
                String localName = rs.getString(2);
                int index = rs.getInt(3);
                int post = rs.getInt(4);
                storedResources.put(new TypedId(RdfType.CLASS, post), new StoredResource(new Uri(ns, localName), new Interval(index, post), RdfType.CLASS));
            }
        }
        if (!kindsAnalyzer.getMetatypeIds().isEmpty()) {
            PreparedStatement metaclassesById = Jdbc.prepared("SELECT DISTINCT ns.att1, c.att2, sc.att2, c.att0, 1 FROM METACLASS c, NAMESPACE ns, SUBMETACLASS sc WHERE c.att1 = ns.att0 AND c.att0 = ANY(?) AND sc.att0 = c.att0 UNION ALL SELECT DISTINCT ns.att1, c.att2, sc.att2, c.att0, 2 FROM METACLASS c, NAMESPACE ns, SUBMETAPROPERTY sc WHERE c.att1 = ns.att0 AND c.att0 = ANY(?) AND sc.att0 = c.att0 ", new Object[0]);
            Array ids = Jdbc.connection().createArrayOf("int", kindsAnalyzer.getMetatypeIds().toArray());
            metaclassesById.setArray(1, ids);
            metaclassesById.setArray(2, ids);
            ResultSet rs3 = metaclassesById.executeQuery();
            while (rs3.next()) {
                RdfType type;
                String ns = rs3.getString(1);
                String localName = rs3.getString(2);
                int index = rs3.getInt(3);
                int post = rs3.getInt(4);
                switch (rs3.getInt(5)) {
                    case 1: {
                        type = RdfType.METACLASS;
                        break;
                    }
                    case 2: {
                        type = RdfType.METAPROPERTY;
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                storedResources.put(new TypedId(type, post), new StoredResource(new Uri(ns, localName), new Interval(index, post), type));
            }
        }
        return new DbSynchronizer(model, storedResources, storedProperties, kindsAnalyzer.getVirtualIds());
    }

    private static class TypedId {
        private final int postId;
        private final RdfType type;
        private static final int CLASS_KIND = DbConstants.getRqlKindFor(RdfSchema.CLASS);
        private static final int METATYPE_KIND = DbConstants.getRqlKindFor(RdfSuite.METACLASS);
        private static final int LITERAL_KIND = DbConstants.getRqlKindFor(RdfSchema.LITERAL);

        TypedId(RdfType type, int postId) {
            this.type = type;
            this.postId = postId;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TypedId)) {
                return false;
            }
            TypedId other = (TypedId)obj;
            return this.postId == other.postId && TypedId.normalized(this.type) == TypedId.normalized(other.type);
        }

        private static RdfType normalized(RdfType type) {
            if (type == RdfType.METAPROPERTY) {
                return RdfType.METACLASS;
            }
            return type;
        }

        public int hashCode() {
            int hash = 3;
            hash = 37 * hash + this.postId;
            hash = 37 * hash + TypedId.normalized(this.type).hashCode();
            return hash;
        }

        public String toString() {
            return "[" + (Object)((Object)this.type) + ", " + this.postId + "]";
        }

        static RdfType fromRqlKind(int rqlKind) {
            if (rqlKind == CLASS_KIND) {
                return RdfType.CLASS;
            }
            if (rqlKind == METATYPE_KIND) {
                return RdfType.METACLASS;
            }
            if (rqlKind == LITERAL_KIND) {
                return RdfType.LITERAL;
            }
            throw new AssertionError((Object)("Unexpected kind: " + rqlKind));
        }
    }

    private static class StoredProperty
    extends StoredResource {
        final TypedId domain;
        final TypedId range;

        StoredProperty(Uri uri, Interval interval, int domainId, int domainKind, int rangeId, int rangeKind) {
            super(uri, interval, RdfType.PROPERTY);
            this.domain = new TypedId(TypedId.fromRqlKind(domainKind), domainId);
            this.range = new TypedId(TypedId.fromRqlKind(rangeKind), rangeId);
        }
    }

    private static class StoredResource {
        final Uri uri;
        final Interval interval;
        final RdfType type;

        StoredResource(Uri uri, Interval interval, RdfType type) {
            this.uri = uri;
            this.interval = interval;
            this.type = type;
        }

        public String toString() {
            return "[" + this.uri + "=" + (Object)((Object)this.type) + " with " + this.interval + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KindsAnalyzer {
        private final Set<Integer> classes = Sets.newHashSet();
        private final Set<Integer> metatypes = Sets.newHashSet();
        private final Map<Integer, Uri> virtualResources = Maps.newHashMap();
        private final Map<TypedId, StoredResource> storedResources;
        private static final Map<Integer, Uri> literalIds = Maps.newHashMap();

        KindsAnalyzer(Map<TypedId, StoredResource> storedResources) {
            this.storedResources = storedResources;
        }

        void recordResourceIdAndKind(int id, int kind) {
            RdfType type = TypedId.fromRqlKind(kind);
            if (this.findLoadedResource(type, id)) {
                return;
            }
            switch (type) {
                case CLASS: {
                    this.classes.add(id);
                    break;
                }
                case METACLASS: {
                    this.metatypes.add(id);
                    break;
                }
                case LITERAL: {
                    Uri literalType = literalIds.get(id);
                    this.virtualResources.put(id, literalType);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown kind: " + kind + ", which is associated with post id: " + id));
                }
            }
        }

        private boolean findLoadedResource(RdfType type, int id) {
            return this.storedResources.containsKey(new TypedId(type, id));
        }

        Set<Integer> getClassIds() {
            return Collections.unmodifiableSet(this.classes);
        }

        Set<Integer> getMetatypeIds() {
            return Collections.unmodifiableSet(this.metatypes);
        }

        Map<Integer, Uri> getVirtualIds() {
            return Collections.unmodifiableMap(this.virtualResources);
        }

        static {
            for (Map.Entry<Uri, Integer> entry : DbConstants.getRqlIds().entrySet()) {
                Uri uri = entry.getKey();
                if (!uri.hasEqualNamespace(XmlSchema.NAMESPACE)) continue;
                literalIds.put(entry.getValue(), uri);
            }
        }
    }
}

