/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2.importer;

import gr.forth.ics.swkm.model2.importer.Configurer;
import gr.forth.ics.swkm.model2.importer.HybridStore;
import gr.forth.ics.swkm.model2.importer.RdfStore;
import gr.forth.ics.swkm.model2.importer.VerticalPartitioningStore;
import javax.sql.DataSource;
import org.springframework.util.Assert;

public class RdfStores {
    private RdfStores() {
    }

    public static RdfStore get(Representation representation, DataSource ds, Configurer conf) {
        Assert.notNull((Object)((Object)representation));
        switch (representation) {
            case VERTICAL_PARTITIONING: {
                return new VerticalPartitioningStore(ds, conf);
            }
            case HYBRID: {
                return new HybridStore(ds, conf);
            }
        }
        throw new UnsupportedRepresentationException(representation);
    }

    public static class UnsupportedRepresentationException
    extends RuntimeException {
        private final Representation representation;

        private UnsupportedRepresentationException(Representation representation) {
            super("Requested representation: '" + (Object)((Object)representation) + "' is not supported");
            this.representation = representation;
        }

        public Representation getRequestedRepresentation() {
            return this.representation;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Representation {
        VERTICAL_PARTITIONING(2),
        HYBRID(4);

        private final int code;

        private Representation(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

