/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2.importer;

import gr.forth.ics.swkm.model2.importer.AbstractStore;
import gr.forth.ics.swkm.model2.importer.Attribute;
import gr.forth.ics.swkm.model2.importer.Configurer;
import gr.forth.ics.swkm.model2.importer.DbConstants;
import gr.forth.ics.swkm.model2.importer.RdfStores;
import gr.forth.ics.swkm.model2.importer.Table;
import gr.forth.ics.swkm.vocabulary.Rdf;
import gr.forth.ics.swkm.vocabulary.RdfSchema;
import gr.forth.ics.swkm.vocabulary.RdfSuite;
import java.sql.SQLException;
import javax.sql.DataSource;

class VerticalPartitioningStore
extends AbstractStore {
    private final SchemaSpecificTables schemaSpecificTables;

    public VerticalPartitioningStore(DataSource dataSource, Configurer conf) {
        super(RdfStores.Representation.VERTICAL_PARTITIONING, dataSource, conf);
        this.schemaSpecificTables = new SchemaSpecificTables(conf);
    }

    protected void initializeRepresentation() throws SQLException {
        this.schemaSpecificTables.createTablePerClassField();
        this.schemaSpecificTables.createRepresentationTables();
        this.schemaSpecificTables.createRepresentationIndexes();
    }

    private static class Resource
    extends Table {
        private final Attribute att0;
        private final Attribute att1;

        Resource(Configurer conf) {
            super("tc" + DbConstants.getIdFor(RdfSchema.RESOURCE));
            this.att0 = this.newAttribute("att0", "VARCHAR(%d)", conf.getMaxUriLength());
            this.att1 = this.newAttribute("att1", "INTEGER");
        }
    }

    private static class DataProperty
    extends Table {
        final Attribute postId = this.newAttribute("att0", "INTEGER PRIMARY KEY");
        final Attribute namespaceId = this.newAttribute("att1", "INTEGER NOT NULL");
        final Attribute localName;
        final Attribute domainId;
        final Attribute rangeId;
        final Attribute domainKind;
        final Attribute rangeKind;
        final Attribute att7;
        final Attribute att8;
        final Attribute att9;

        DataProperty(Configurer conf) {
            super("t" + DbConstants.getIdFor(RdfSuite.DATA_PROPERTY));
            this.localName = this.newAttribute("att2", "VARCHAR(%d) NOT NULL", conf.getMaxLiteralLength());
            this.domainId = this.newAttribute("att3", "INTEGER NOT NULL");
            this.rangeId = this.newAttribute("att4", "INTEGER NOT NULL");
            this.domainKind = this.newAttribute("att5", "INTEGER NOT NULL");
            this.rangeKind = this.newAttribute("att6", "INTEGER NOT NULL");
            this.att7 = this.newAttribute("att7", "INTEGER");
            this.att8 = this.newAttribute("att8", "INTEGER");
            this.att9 = this.newAttribute("att9", "INTEGER");
        }
    }

    private static class Property
    extends Table {
        final Attribute postId = this.newAttribute("att0", "INTEGER PRIMARY KEY");
        final Attribute namespaceId = this.newAttribute("att1", "INTEGER NOT NULL");
        final Attribute localName;
        final Attribute domainId;
        final Attribute rangeId;
        final Attribute domainKind;
        final Attribute rangeKind;
        final Attribute att7;
        final Attribute att8;
        final Attribute att9;

        Property(Configurer conf) {
            super("t" + DbConstants.getIdFor(Rdf.PROPERTY));
            this.localName = this.newAttribute("att2", "VARCHAR(%d) NOT NULL", conf.getMaxLocalPartLength());
            this.domainId = this.newAttribute("att3", "INTEGER NOT NULL");
            this.rangeId = this.newAttribute("att4", "INTEGER NOT NULL");
            this.domainKind = this.newAttribute("att5", "INTEGER NOT NULL");
            this.rangeKind = this.newAttribute("att6", "INTEGER NOT NULL");
            this.att7 = this.newAttribute("att7", "INTEGER");
            this.att8 = this.newAttribute("att8", "INTEGER");
            this.att9 = this.newAttribute("att9", "INTEGER");
        }
    }

    private static class Classes
    extends Table {
        final Attribute att0 = this.newAttribute("att0", "INTEGER PRIMARY KEY");
        final Attribute att1 = this.newAttribute("att1", "INTEGER NOT NULL");
        final Attribute att2;
        final Attribute att3;

        Classes(Configurer conf) {
            super("t" + DbConstants.getIdFor(RdfSchema.CLASS));
            this.att2 = this.newAttribute("att2", "VARCHAR(%d) NOT NULL", conf.getMaxLocalPartLength());
            this.att3 = this.newAttribute("att3", "INTEGER");
        }
    }

    private class SchemaSpecificTables {
        private final Classes classes;
        private final Property property;
        private final DataProperty dataProperty;
        private final Resource resource;

        SchemaSpecificTables(Configurer conf) {
            this.classes = new Classes(conf);
            this.property = new Property(conf);
            this.dataProperty = new DataProperty(conf);
            this.resource = new Resource(conf);
        }

        private void createTablePerClassField() throws SQLException {
            Table.createAllTablesDeclaredAsFields(this);
        }

        private void createRepresentationTables() throws SQLException {
            this.classes.insert(this.classes.att0, this.classes.att1, this.classes.att2).values(DbConstants.getIdFor(RdfSchema.RESOURCE), 2, "Resource");
        }

        private void createRepresentationIndexes() throws SQLException {
            if (VerticalPartitioningStore.this.conf.createIndexes()) {
                this.resource.indexOn("idx" + DbConstants.getIdFor(RdfSchema.RESOURCE) + "_uri", this.resource.att0);
                this.property.indexOn("p_uri_idx", this.property.localName);
                this.dataProperty.indexOn("dp_uri_idx", this.dataProperty.localName);
            }
        }
    }
}

