/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2.index;

import gr.forth.ics.swkm.model2.LiteralNode;
import gr.forth.ics.swkm.model2.Model;
import gr.forth.ics.swkm.model2.ObjectNode;
import gr.forth.ics.swkm.model2.RdfNode;
import gr.forth.ics.swkm.model2.RdfType;
import gr.forth.ics.swkm.model2.Resource;
import gr.forth.ics.swkm.model2.Triple;
import gr.forth.ics.swkm.model2.Triples;
import gr.forth.ics.swkm.model2.Uri;
import gr.forth.ics.swkm.model2.event.TypeChange;
import gr.forth.ics.swkm.model2.index.Index;
import gr.forth.ics.swkm.model2.index.ModelIndexer;
import gr.forth.ics.swkm.model2.index.ModelView;
import gr.forth.ics.swkm.model2.index.NamedGraphIndexer;
import gr.forth.ics.swkm.model2.index.NamespaceIndexer;
import gr.forth.ics.swkm.model2.index.ObjectViewSupport;
import gr.forth.ics.swkm.model2.index.TripleBasedObjectViewSupport;
import gr.forth.ics.swkm.model2.index.TripleDeletionListener;
import gr.forth.ics.swkm.model2.index.common.EmptyIndex;
import gr.forth.ics.swkm.model2.index.common.IteratorChooser;
import gr.forth.ics.swkm.model2.index.common.IteratorSpecializationChooser;
import gr.forth.ics.swkm.model2.index.common.SuperClassIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractModelIndexer
implements ModelIndexer {
    private Model model;
    private ModelView modelView;
    private NamespaceIndexer namespaceIndexer;
    protected NamedGraphIndexer graphIndexer;

    public AbstractModelIndexer(NamedGraphIndexer graphIndexer) {
        this.graphIndexer = graphIndexer;
    }

    protected Model model() {
        return this.model;
    }

    protected ModelView modelView() {
        return this.modelView;
    }

    protected NamespaceIndexer namespaceIndexer() {
        return this.namespaceIndexer;
    }

    @Override
    public void setModelView(ModelView modelView) {
        this.modelView = modelView;
    }

    @Override
    public void setModel(Model model) {
        this.model = model;
        this.namespaceIndexer = new NamespaceIndexer(model);
    }

    @Override
    public void removeTripleFromNamedGraph(Resource namedGraph, Triple triple) {
        this.graphIndexer.removeTriple(namedGraph, triple);
    }

    @Override
    public Iterable<RdfNode> find(RdfType type) {
        if (type.isLiteral()) {
            return this.findRdfNodes(this.modelView.allLiterals());
        }
        if (type == RdfType.NAMED_GRAPH) {
            return this.findNamedGraphs(this.graphIndexer);
        }
        return this.findResource(this.modelView.allResources(), type);
    }

    private Iterable<RdfNode> findRdfNodes(final Iterable<LiteralNode> iterable) {
        return new Iterable<RdfNode>(){

            @Override
            public Iterator<RdfNode> iterator() {
                return new SuperClassIterator(iterable.iterator());
            }
        };
    }

    private Iterable<RdfNode> findNamedGraphs(final Iterable<Resource> iterable) {
        return new Iterable<RdfNode>(){

            @Override
            public Iterator<RdfNode> iterator() {
                return new SuperClassIterator(iterable.iterator());
            }
        };
    }

    private Iterable<RdfNode> findResource(final Iterable<Resource> allResources, final RdfType type) {
        return new Iterable<RdfNode>(){

            @Override
            public Iterator<RdfNode> iterator() {
                return new IteratorSpecializationChooser<RdfNode, Resource>(allResources.iterator()){

                    @Override
                    protected boolean accept(RdfNode element) {
                        return element.type() == type && element.hasTriples();
                    }

                    @Override
                    protected RdfNode specialize(Resource element) {
                        return element;
                    }
                };
            }
        };
    }

    @Override
    public Index indexFor(RdfNode node, TypeChange typeChange) {
        return EmptyIndex.instance;
    }

    @Override
    public Iterable<Resource> findInNamespace(RdfType type, Uri namespace) {
        return this.namespaceIndexer.findInNamespace(type, namespace);
    }

    protected static Triples findTriples(Collection<Triple> matchingSPO, Collection<Triple> matchingNG, Resource g, ObjectNode s, Resource p, RdfNode o) {
        if (matchingSPO.size() < matchingNG.size()) {
            return AbstractModelIndexer.findTriples(matchingSPO, g);
        }
        return AbstractModelIndexer.findTriples(matchingNG, s, p, o);
    }

    protected static Triples findTriples(final Iterable<Triple> triples, final Resource g) {
        return new Triples(new Iterable<Triple>(){

            @Override
            public Iterator<Triple> iterator() {
                return new IteratorChooser<Triple>(triples.iterator()){

                    @Override
                    protected boolean accept(Triple triple) {
                        return triple.graphs().contains(g);
                    }
                };
            }
        });
    }

    protected static Triples findTriples(final Iterable<Triple> triples, final ObjectNode s, final Resource p, final RdfNode o) {
        return new Triples(new Iterable<Triple>(){

            @Override
            public Iterator<Triple> iterator() {
                return new IteratorChooser<Triple>(triples.iterator()){

                    @Override
                    protected boolean accept(Triple triple) {
                        return AbstractModelIndexer.match(s, p, o, triple);
                    }
                };
            }
        });
    }

    @Override
    public ObjectViewSupport objectViewSupport() {
        return new TripleBasedObjectViewSupport(this, this.model);
    }

    protected void deleteFromNamedGraph(Resource g, ObjectNode s, Resource p, RdfNode o, TripleDeletionListener l) {
        Iterator<Triple> iterator = this.graphIndexer.get(g).iterator();
        while (iterator.hasNext()) {
            Triple triple = iterator.next();
            if (!AbstractModelIndexer.match(s, p, o, triple)) continue;
            iterator.remove();
            l.tripleRemovedFromNamedGraph(g, triple);
        }
    }

    protected static boolean match(ObjectNode s, Resource p, RdfNode o, Triple triple) {
        return !(s != null && s != triple.subject() || p != null && p != triple.predicate() || o != null && o != triple.object());
    }

    @Override
    public Set<Uri> namespaces() {
        return this.namespaceIndexer.namespaces();
    }
}

