/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2.index;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import gr.forth.ics.swkm.model2.ObjectNode;
import gr.forth.ics.swkm.model2.RdfNode;
import gr.forth.ics.swkm.model2.Resource;
import gr.forth.ics.swkm.model2.Triple;
import gr.forth.ics.swkm.model2.index.AbstractModelIndexer;
import gr.forth.ics.swkm.model2.index.NamedGraphIndexerImpl;
import gr.forth.ics.swkm.model2.index.TripleDeletionListener;
import gr.forth.ics.swkm.model2.index.common.Multikey;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MultimapsModelIndexer
extends AbstractModelIndexer {
    private Multimap<ObjectNode, Triple> subjects = new LinkedListMultimap();
    private Multimap<Resource, Triple> predicates = new LinkedListMultimap();
    private Multimap<RdfNode, Triple> objects = new LinkedListMultimap();
    private Multimap<Multikey, Triple> subjectPredicates = new LinkedListMultimap();
    private Multimap<Multikey, Triple> predicateObjects;
    private Multimap<Multikey, Triple> subjectObjects = new LinkedListMultimap();
    private Map<Multikey, Triple> subjectPredicateObjects;

    public MultimapsModelIndexer() {
        super(new NamedGraphIndexerImpl());
        this.predicateObjects = new LinkedListMultimap();
        this.subjectPredicateObjects = new HashMap<Multikey, Triple>();
    }

    @Override
    public boolean containsTriple(Triple triple) {
        return this.subjectPredicateObjects.containsKey(new Multikey(triple.subject(), triple.predicate(), triple.object()));
    }

    @Override
    public Iterable<Triple> findTriples(Resource g, ObjectNode s, Resource p, RdfNode o) {
        Collection<Triple> triples = this.findTriples(s, p, o);
        if (g == null) {
            return triples;
        }
        Collection<Triple> ngTriples = this.graphIndexer.get(g);
        return AbstractModelIndexer.findTriples(triples, ngTriples, g, s, p, o);
    }

    private Collection<Triple> findTriples(ObjectNode subject, Resource predicate, RdfNode object) {
        List triples;
        int count = 0;
        if (subject != null) {
            count |= 4;
        }
        if (predicate != null) {
            count |= 2;
        }
        if (object != null) {
            count |= 1;
        }
        switch (count) {
            case 0: {
                triples = this.subjectPredicateObjects.values();
                break;
            }
            case 1: {
                triples = this.objects.get((Object)object);
                break;
            }
            case 2: {
                triples = this.predicates.get((Object)predicate);
                break;
            }
            case 3: {
                triples = this.predicateObjects.get((Object)new Multikey(predicate, object));
                break;
            }
            case 4: {
                triples = this.subjects.get((Object)subject);
                break;
            }
            case 5: {
                triples = this.subjectObjects.get((Object)new Multikey(subject, object));
                break;
            }
            case 6: {
                triples = this.subjectPredicates.get((Object)new Multikey(subject, predicate));
                break;
            }
            default: {
                Triple triple = this.subjectPredicateObjects.get(new Multikey(subject, predicate, object));
                triples = triple == null ? Collections.emptyList() : this.singletonList(triple);
            }
        }
        return triples == null ? Collections.emptyList() : triples;
    }

    private Collection<Triple> singletonList(final Triple triple) {
        return new AbstractList<Triple>(){

            @Override
            public Triple get(int index) {
                switch (index) {
                    case 0: {
                        return triple;
                    }
                }
                throw new IndexOutOfBoundsException("Index: " + index);
            }

            @Override
            public int size() {
                return 1;
            }

            @Override
            public Iterator<Triple> iterator() {
                return new Iterator<Triple>(){
                    boolean returned = false;

                    @Override
                    public boolean hasNext() {
                        return !this.returned;
                    }

                    @Override
                    public Triple next() {
                        if (this.returned) {
                            throw new NoSuchElementException();
                        }
                        this.returned = true;
                        return triple;
                    }

                    @Override
                    public void remove() {
                        MultimapsModelIndexer.this.subjectPredicateObjects.remove(triple);
                    }
                };
            }
        };
    }

    @Override
    public void add(Resource namedGraph, Triple triple) {
        ObjectNode s = triple.subject();
        Resource p = triple.predicate();
        RdfNode o = triple.object();
        this.graphIndexer.add(namedGraph, triple);
        if (this.subjectPredicateObjects.put(new Multikey(s, p, o), triple) != null) {
            return;
        }
        this.subjects.put((Object)s, (Object)triple);
        this.predicates.put((Object)p, (Object)triple);
        this.objects.put((Object)o, (Object)triple);
        this.subjectPredicates.put((Object)new Multikey(s, p), (Object)triple);
        this.subjectObjects.put((Object)new Multikey(s, o), (Object)triple);
        this.predicateObjects.put((Object)new Multikey(p, o), (Object)triple);
    }

    private void delete(Triple triple, boolean tryDeleteFromAll) {
        RdfNode o;
        Resource p;
        ObjectNode s = triple.subject();
        if (this.subjectPredicateObjects.remove(new Multikey(s, p = triple.predicate(), o = triple.object())) == null && !tryDeleteFromAll) {
            return;
        }
        this.subjects.remove((Object)s, (Object)triple);
        this.predicates.remove((Object)p, (Object)triple);
        this.objects.remove((Object)o, (Object)triple);
        this.subjectPredicates.remove((Object)new Multikey(s, p), (Object)triple);
        this.subjectObjects.remove((Object)new Multikey(s, o), (Object)triple);
        this.predicateObjects.remove((Object)new Multikey(p, o), (Object)triple);
        this.graphIndexer.removeTriple(triple);
    }

    @Override
    public void delete(Triple triple) {
        this.delete(triple, false);
    }

    @Override
    public void deleteTriples(Resource g, ObjectNode s, Resource p, RdfNode o, TripleDeletionListener listener) {
        if (g != null) {
            this.deleteFromNamedGraph(g, s, p, o, listener);
            return;
        }
        Iterator<Triple> triples = this.findTriples(s, p, o).iterator();
        while (triples.hasNext()) {
            Triple triple = triples.next();
            triples.remove();
            this.delete(triple, false);
            listener.tripleDeleted(triple);
        }
    }

    @Override
    public int tripleCount() {
        return this.subjectPredicateObjects.size();
    }
}

