/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2.index;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import gr.forth.ics.swkm.model2.Model;
import gr.forth.ics.swkm.model2.RdfNode;
import gr.forth.ics.swkm.model2.RdfType;
import gr.forth.ics.swkm.model2.Resource;
import gr.forth.ics.swkm.model2.Uri;
import gr.forth.ics.swkm.model2.event.RdfNodeListener;
import gr.forth.ics.swkm.model2.event.TypeChange;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NamespaceIndexer {
    private final Map<Uri, Multimap<RdfType, Resource>> index = Maps.newHashMap();

    NamespaceIndexer(Model model) {
        model.addRdfNodeListener(new NamespaceIndexUpdater());
    }

    Set<Uri> namespaces() {
        return Collections.unmodifiableSet(this.index.keySet());
    }

    Iterable<Resource> findInNamespace(RdfType type, Uri namespace) {
        if (!type.isSchema()) {
            throw new IllegalArgumentException("Requested type: " + (Object)((Object)type) + " is not schema");
        }
        if (namespace.getLocalName().length() > 0) {
            throw new IllegalArgumentException("Uri: '" + namespace + "' is not purely a namespace; it also contains a local part");
        }
        Multimap<RdfType, Resource> map = this.index.get(namespace);
        if (map == null) {
            return Iterables.emptyIterable();
        }
        return Iterables.unmodifiableIterable((Iterable)map.get((Object)type));
    }

    private void addEntry(Resource resource) {
        if (!resource.type().isSchema()) {
            return;
        }
        Uri namespace = resource.getUri().getNamespaceUri();
        HashMultimap map = this.index.get(namespace);
        if (map == null) {
            map = Multimaps.newHashMultimap();
            this.index.put(namespace, (Multimap<RdfType, Resource>)map);
        }
        map.put((Object)resource.type(), (Object)resource);
    }

    private void removeEntry(Resource resource, RdfType type) {
        if (!type.isSchema()) {
            return;
        }
        Uri namespace = resource.getUri().getNamespaceUri();
        Multimap<RdfType, Resource> map = this.index.get(namespace);
        if (map == null) {
            return;
        }
        map.remove((Object)type, (Object)resource);
        if (map.isEmpty()) {
            this.index.remove(namespace);
        }
    }

    void clear() {
        this.index.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NamespaceIndexUpdater
    implements RdfNodeListener {
        private NamespaceIndexUpdater() {
        }

        @Override
        public void onNodeAddition(RdfNode node) {
            if (!node.isResource()) {
                return;
            }
            NamespaceIndexer.this.addEntry((Resource)node);
        }

        @Override
        public void onNodeDeletion(RdfNode node) {
            if (!node.isResource()) {
                return;
            }
            NamespaceIndexer.this.removeEntry((Resource)node, node.type());
        }

        @Override
        public void onTypeChange(RdfNode node, RdfType oldType, List<TypeChange> changeStack) {
            if (!node.isResource()) {
                return;
            }
            Resource resource = (Resource)node;
            NamespaceIndexer.this.removeEntry(resource, oldType);
            NamespaceIndexer.this.addEntry(resource);
        }
    }
}

