/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2.index;

import gr.forth.ics.swkm.model2.RdfNode;
import gr.forth.ics.swkm.model2.Triple;
import gr.forth.ics.swkm.model2.index.Index;
import gr.forth.ics.swkm.model2.index.common.CollectionFactory;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class NodeIndex
implements Index {
    protected RdfNode node;
    protected static CollectionFactory<List<Triple>> factory = CollectionFactory.arrayListFactory;

    NodeIndex(RdfNode node) {
        this.node = node;
    }

    protected List<Triple> getList(List<Triple> triples) {
        return triples == null ? Collections.emptyList() : triples;
    }

    List<Triple> subjects() {
        return Collections.emptyList();
    }

    List<Triple> predicates() {
        return Collections.emptyList();
    }

    List<Triple> objects() {
        return Collections.emptyList();
    }

    List<Triple> namedGraphs() {
        return Collections.emptyList();
    }

    protected List<Triple> addTo(List<Triple> list, Triple triple) {
        if (list == null) {
            list = factory.newInstance();
        }
        list.add(triple);
        return list;
    }

    void addToSubjects(Triple triple) {
        throw new UnsupportedOperationException(this.node.getClass().getCanonicalName() + " cannot be subject of a triple");
    }

    void addToPredicates(Triple triple) {
        throw new UnsupportedOperationException(this.node.getClass().getCanonicalName() + " cannot be predicate of a triple");
    }

    void addToObjects(Triple triple) {
        throw new UnsupportedOperationException(this.node.getClass().getCanonicalName() + " cannot be object of a triple");
    }

    void addToNamedGraphs(Triple triple) {
        throw new UnsupportedOperationException(this.node.getClass().getCanonicalName() + " is not a named graph.");
    }

    void removeFrom(List<Triple> list, Triple triple) {
        if (list != null) {
            list.remove(triple);
        }
    }

    @Override
    public RdfNode getNode() {
        return this.node;
    }

    static NodeIndex getIndex(RdfNode node) {
        return (NodeIndex)node.getIndex();
    }
}

