/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2.index;

import gr.forth.ics.swkm.model2.Model;
import gr.forth.ics.swkm.model2.ObjectNode;
import gr.forth.ics.swkm.model2.RdfNode;
import gr.forth.ics.swkm.model2.RdfType;
import gr.forth.ics.swkm.model2.Resource;
import gr.forth.ics.swkm.model2.Triple;
import gr.forth.ics.swkm.model2.event.TypeChange;
import gr.forth.ics.swkm.model2.index.AbstractModelIndexer;
import gr.forth.ics.swkm.model2.index.BlankNodeIndex;
import gr.forth.ics.swkm.model2.index.Index;
import gr.forth.ics.swkm.model2.index.LiteralNodeIndex;
import gr.forth.ics.swkm.model2.index.ModelIndexer;
import gr.forth.ics.swkm.model2.index.NamedGraphIndex;
import gr.forth.ics.swkm.model2.index.NodeIndex;
import gr.forth.ics.swkm.model2.index.NodeListsNamedGraphIndexer;
import gr.forth.ics.swkm.model2.index.ResourceIndex;
import gr.forth.ics.swkm.model2.index.TripleDeletionListener;
import gr.forth.ics.swkm.model2.index.common.CollectionFactory;
import gr.forth.ics.swkm.model2.index.common.IteratorChooser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NodeListsModelIndexer
extends AbstractModelIndexer
implements ModelIndexer {
    private final List<Triple> allTriples;

    public NodeListsModelIndexer() {
        this(CollectionFactory.arrayListFactory);
    }

    public NodeListsModelIndexer(CollectionFactory<List<Triple>> factory) {
        super(new NodeListsNamedGraphIndexer());
        NodeIndex.factory = factory;
        this.allTriples = new ArrayList<Triple>(128);
    }

    @Override
    public void setModel(Model model) {
        super.setModel(model);
        model.addRdfNodeListener((NodeListsNamedGraphIndexer)this.graphIndexer);
    }

    @Override
    public void add(Resource namedGraph, Triple triple) {
        this.graphIndexer.add(namedGraph, triple);
        if (this.containsTriple(triple)) {
            return;
        }
        this.allTriples.add(triple);
        NodeIndex.getIndex(triple.subject()).addToSubjects(triple);
        NodeIndex.getIndex(triple.predicate()).addToPredicates(triple);
        NodeIndex.getIndex(triple.object()).addToObjects(triple);
    }

    private NodeIndex newIndex(RdfNode node) {
        if (node.type().isNamedGraph()) {
            return new NamedGraphIndex(node);
        }
        if (node.isBlankNode()) {
            return new BlankNodeIndex(node);
        }
        if (node.isLiteral()) {
            return new LiteralNodeIndex(node);
        }
        return new ResourceIndex(node);
    }

    @Override
    public Index indexFor(RdfNode node, TypeChange typeChange) {
        RdfType oldType;
        NodeIndex currentIndex = NodeIndex.getIndex(node);
        if (currentIndex == null) {
            return this.newIndex(node);
        }
        RdfType currentType = node.type();
        if (typeChange == null || (oldType = typeChange.oldType()).equals((Object)currentType) || oldType.isSchema() || oldType.isNamedGraph()) {
            return currentIndex;
        }
        if (currentType == RdfType.NAMED_GRAPH) {
            return new NamedGraphIndex((ResourceIndex)node.getIndex());
        }
        return currentIndex;
    }

    @Override
    public boolean containsTriple(Triple triple) {
        return this.findTriples(null, triple.subject(), triple.predicate(), triple.object()).iterator().hasNext();
    }

    @Override
    public Iterable<Triple> findTriples(Resource g, ObjectNode s, Resource p, RdfNode o) {
        return this.findTriples(g, s, p, o, new TripleDeletionListener(){

            public void tripleDeleted(Triple triple) {
            }

            public void tripleRemovedFromNamedGraph(Resource namedGraph, Triple triple) {
            }
        });
    }

    private Collection<Triple> smallestList(Collection<Triple> c1, Collection<Triple> c2) {
        return c1.size() < c2.size() ? c1 : c2;
    }

    private Iterable<Triple> findTriples(final Resource g, final ObjectNode s, final Resource p, final RdfNode o, final TripleDeletionListener listener) {
        Collection<Triple> tmp;
        Collection<Triple> triples = this.allTriples;
        if (s != null) {
            tmp = NodeIndex.getIndex(s).subjects();
            triples = this.smallestList(tmp, triples);
        }
        if (p != null) {
            tmp = NodeIndex.getIndex(p).predicates();
            triples = this.smallestList(tmp, triples);
        }
        if (o != null) {
            tmp = NodeIndex.getIndex(o).objects();
            triples = this.smallestList(tmp, triples);
        }
        if (g != null) {
            tmp = this.graphIndexer.get(g);
            triples = this.smallestList(tmp, triples);
        }
        final List<Triple> iterable = triples;
        return new Iterable<Triple>(){

            @Override
            public Iterator<Triple> iterator() {
                return new IteratorChooser<Triple>(iterable.iterator()){

                    @Override
                    protected boolean accept(Triple t) {
                        return !(g != null && !t.graphs().contains(g) || s != null && s != t.subject() || p != null && p != t.predicate() || o != null && o != t.object());
                    }

                    @Override
                    public void removeAll() {
                        if (this.next != null) {
                            this.iterator.remove();
                            NodeListsModelIndexer.this.delete((Triple)this.next, true);
                            listener.tripleDeleted((Triple)this.next);
                        }
                        while (this.iterator.hasNext()) {
                            Triple t = (Triple)this.iterator.next();
                            if (!this.accept(t)) continue;
                            this.iterator.remove();
                            NodeListsModelIndexer.this.delete(t, true);
                            listener.tripleDeleted(t);
                        }
                    }
                };
            }
        };
    }

    @Override
    public void delete(Triple triple) {
        this.delete(triple, false);
    }

    private void delete(Triple triple, boolean tryDeleteFromAll) {
        if (!tryDeleteFromAll && !this.containsTriple(triple)) {
            return;
        }
        this.allTriples.remove(triple);
        NodeIndex index = NodeIndex.getIndex(triple.subject());
        index.removeFrom(index.subjects(), triple);
        index = NodeIndex.getIndex(triple.predicate());
        index.removeFrom(index.predicates(), triple);
        index = NodeIndex.getIndex(triple.object());
        index.removeFrom(index.objects(), triple);
        this.graphIndexer.removeTriple(triple);
    }

    @Override
    public void deleteTriples(Resource g, ObjectNode s, Resource p, RdfNode o, TripleDeletionListener listener) {
        if (g != null) {
            this.deleteFromNamedGraph(g, s, p, o, listener);
            return;
        }
        ((IteratorChooser)this.findTriples(g, s, p, o, listener).iterator()).removeAll();
    }

    @Override
    public int tripleCount() {
        return this.allTriples.size();
    }
}

