/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2.index;

import com.google.common.collect.Iterables;
import gr.forth.ics.swkm.model2.Triple;
import gr.forth.ics.swkm.model2.index.QueryTriple;
import gr.forth.ics.swkm.model2.index.TriplesComparator;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TreeMultiMap {
    private final TreeMap<QueryTriple, Collection<Triple>> map;

    TreeMultiMap() {
        this(TriplesComparator.instance);
    }

    TreeMultiMap(Comparator<Triple> comparator) {
        this.map = new TreeMap(comparator);
    }

    int size() {
        return this.map.size();
    }

    boolean isEmpty() {
        return this.map.isEmpty();
    }

    boolean containsKey(QueryTriple key) {
        return this.map.containsKey(key);
    }

    void put(QueryTriple key, Triple value) {
        Collection<Triple> collection = this.map.get(key);
        if (collection == null) {
            collection = new HashSet<Triple>();
            this.map.put(key, collection);
        }
        collection.add(value);
    }

    public void clear() {
        this.map.clear();
    }

    public Collection<Triple> get(QueryTriple key) {
        return this.map.get(key);
    }

    Set<QueryTriple> keySet() {
        return this.map.keySet();
    }

    boolean remove(QueryTriple key, Triple value) {
        Collection<Triple> collection = this.map.get(key);
        if (collection == null) {
            return false;
        }
        return collection.remove(value);
    }

    Iterable<Triple> subSet(QueryTriple fromElement, QueryTriple toElement) {
        Collection<Collection<Triple>> results = this.map.subMap(fromElement, toElement).values();
        return Iterables.concat(results);
    }
}

