/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2.index.common;

import gr.forth.ics.swkm.model2.Triple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface CollectionFactory<E extends Collection<Triple>> {
    public static final CollectionFactory<List<Triple>> linkedListFactory = new CollectionFactory<List<Triple>>(){

        @Override
        public LinkedList<Triple> newInstance() {
            return new LinkedList<Triple>();
        }
    };
    public static final CollectionFactory<List<Triple>> arrayListFactory = new CollectionFactory<List<Triple>>(){

        @Override
        public List<Triple> newInstance() {
            return new ArrayList<Triple>(2);
        }
    };
    public static final CollectionFactory<Set<Triple>> hashSetFactory = new CollectionFactory<Set<Triple>>(){

        @Override
        public HashSet<Triple> newInstance() {
            return new HashSet<Triple>();
        }
    };
    public static final CollectionFactory<Set<Triple>> linkedHashSetFactory = new CollectionFactory<Set<Triple>>(){

        @Override
        public LinkedHashSet<Triple> newInstance() {
            return new LinkedHashSet<Triple>();
        }
    };

    public E newInstance();
}

