/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2.index.common;

import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IteratorChooser<E>
implements Iterator<E> {
    protected final Iterator<E> iterator;
    protected E next;
    protected E current;

    protected IteratorChooser(Iterator<E> iterator) {
        this.iterator = iterator;
        this.proceed();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        try {
            E e = this.next;
            return e;
        }
        finally {
            this.proceed();
        }
    }

    private void proceed() {
        this.current = this.next;
        while (this.iterator.hasNext()) {
            this.next = this.iterator.next();
            if (!this.accept(this.next)) continue;
            return;
        }
        this.next = null;
    }

    protected abstract boolean accept(E var1);

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void removeAll() {
        throw new UnsupportedOperationException();
    }
}

