/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2.io;

import gr.forth.ics.swkm.model2.Literal;
import gr.forth.ics.swkm.model2.Model;
import gr.forth.ics.swkm.model2.ObjectNode;
import gr.forth.ics.swkm.model2.RdfNode;
import gr.forth.ics.swkm.model2.Resource;
import gr.forth.ics.swkm.model2.Uri;
import gr.forth.ics.swkm.vocabulary.RdfSuite;
import org.openrdf.model.BNode;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;

class ModelFeeder
implements RDFHandler {
    private final Model target;
    private final Resource defaultNamedGraph;

    ModelFeeder(Model target, Uri defaultNamedGraph) {
        this.target = target;
        if (defaultNamedGraph == null) {
            defaultNamedGraph = RdfSuite.DEFAULT_GRAPH_URI;
        }
        this.defaultNamedGraph = target.mapResource(defaultNamedGraph);
    }

    public void startRDF() throws RDFHandlerException {
    }

    public void handleComment(String comment) throws RDFHandlerException {
    }

    public void handleNamespace(String prefix, String namespace) throws RDFHandlerException {
    }

    public void handleStatement(Statement statement) throws RDFHandlerException {
        ObjectNode subject = (ObjectNode)this.map((Value)statement.getSubject());
        Resource predicate = (Resource)this.map((Value)statement.getPredicate());
        RdfNode object = this.map(statement.getObject());
        Resource namedGraph = statement.getContext() == null ? this.defaultNamedGraph : (Resource)this.map((Value)statement.getContext());
        this.target.add(namedGraph, subject, predicate, object);
    }

    public void endRDF() throws RDFHandlerException {
    }

    private RdfNode map(Value object) {
        if (object instanceof URI) {
            URI uri = (URI)object;
            return this.target.mapResource(new Uri(uri.getNamespace(), uri.getLocalName()));
        }
        if (object instanceof BNode) {
            BNode bNode = (BNode)object;
            return this.target.mapBlankNode(bNode.getID());
        }
        org.openrdf.model.Literal literal = (org.openrdf.model.Literal)object;
        Literal swkmLiteral = null;
        swkmLiteral = literal.getDatatype() != null ? Literal.createWithType(literal.getLabel(), Uri.parse(literal.getDatatype().toString())) : Literal.createWithLanguage(literal.getLabel(), literal.getLanguage());
        return this.target.mapLiteral(swkmLiteral);
    }
}

