/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2.io;

import com.google.common.base.Preconditions;
import gr.forth.ics.swkm.model2.BlankNode;
import gr.forth.ics.swkm.model2.LiteralNode;
import gr.forth.ics.swkm.model2.Model;
import gr.forth.ics.swkm.model2.RdfNode;
import gr.forth.ics.swkm.model2.RdfType;
import gr.forth.ics.swkm.model2.Resource;
import gr.forth.ics.swkm.model2.Triple;
import gr.forth.ics.swkm.model2.Uri;
import gr.forth.ics.swkm.model2.io.BlankNodesPolicy;
import gr.forth.ics.swkm.model2.io.Format;
import gr.forth.ics.swkm.model2.io.ModelFeeder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.model.impl.ContextStatementImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.RDFParserFactory;
import org.openrdf.rio.RDFParserRegistry;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.RDFWriterFactory;
import org.openrdf.rio.RDFWriterRegistry;
import org.springframework.util.Assert;

public class RdfIO {
    private RdfIO() {
    }

    public static InputWithoutBase read(InputStream in, Format format) {
        return RdfIO.read(new InputStreamReader(in), format);
    }

    public static InputWithoutBase read(Reader in, Format format) {
        Assert.notNull((Object)in, (String)"Reader");
        Assert.notNull((Object)((Object)format), (String)"Format");
        return new InputWithoutBase(in, format);
    }

    public static InputWithoutBase read(File file, Format format) throws FileNotFoundException {
        Assert.notNull((Object)file, (String)"File");
        Assert.notNull((Object)((Object)format), (String)"Format");
        return new InputWithoutBase(new InputStreamReader(new BufferedInputStream(new FileInputStream(file))), format);
    }

    public static InputWithoutBase read(URL url, Format format) throws IOException {
        Assert.notNull((Object)url, (String)"URL");
        Assert.notNull((Object)((Object)format), (String)"Format");
        return new InputWithoutBase(new InputStreamReader(new BufferedInputStream(url.openStream())), format);
    }

    public static InputWithoutBase read(String text, Format format) {
        return RdfIO.read(new StringReader(text), format);
    }

    public static ModelWriterWithoutBase write(Model model, Format format) {
        Assert.notNull((Object)model, (String)"Model");
        Assert.notNull((Object)((Object)format), (String)"Format");
        return new ModelWriterWithoutBase(model, format.toSesameFormat());
    }

    private static Statement toStatement(Resource namedGraph, Triple triple) {
        URI c = namedGraph == namedGraph.owner().defaultNamedGraph() ? null : RdfIO.toURI(namedGraph);
        URI s = triple.subject().isResource() ? RdfIO.toURI((Resource)triple.subject()) : RdfIO.toBNode((BlankNode)triple.subject());
        URI p = RdfIO.toURI(triple.predicate());
        URI o = triple.object().isResource() ? RdfIO.toURI((Resource)triple.object()) : (triple.object().isBlankNode() ? RdfIO.toBNode((BlankNode)triple.object()) : RdfIO.toLiteral((LiteralNode)triple.object()));
        return new ContextStatementImpl((org.openrdf.model.Resource)s, p, (Value)o, (org.openrdf.model.Resource)c);
    }

    private static URI toURI(Resource resource) {
        return new URIImpl(resource.getUri().toString());
    }

    private static BNode toBNode(BlankNode blankNode) {
        return new BNodeImpl(blankNode.getId());
    }

    private static Literal toLiteral(LiteralNode literal) {
        String value = literal.getLiteral().getValue();
        if (literal.getLiteral().hasType()) {
            return new LiteralImpl(value, (URI)new URIImpl(literal.getLiteral().getType().toString()));
        }
        if (literal.getLiteral().hasLanguage()) {
            return new LiteralImpl(value, literal.getLiteral().getLanguage());
        }
        return new LiteralImpl(value);
    }

    public static class ModelWriterWithBase {
        protected final Model model;
        protected final RDFFormat format;
        private final Uri baseUri;

        private ModelWriterWithBase(Model model, RDFFormat format) {
            this(model, format, (Uri)null);
        }

        private ModelWriterWithBase(Model model, RDFFormat format, Uri baseUri) {
            this.model = model;
            this.format = format;
            this.baseUri = baseUri;
        }

        public void toFile(File file) throws IOException {
            this.toStream(new BufferedOutputStream(new FileOutputStream(file)));
        }

        public void toStream(OutputStream out) throws IOException {
            Assert.notNull((Object)out, (String)"OutputStream");
            this.write(((RDFWriterFactory)RDFWriterRegistry.getInstance().get((Object)this.format)).getWriter(out));
        }

        public void toWriter(Writer out) throws IOException {
            Assert.notNull((Object)out, (String)"Writer");
            this.write(((RDFWriterFactory)RDFWriterRegistry.getInstance().get((Object)this.format)).getWriter(out));
        }

        public String toString() {
            StringWriter sw = new StringWriter(1024);
            try {
                this.toWriter(sw);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            return sw.toString();
        }

        protected void handleBaseUri(RDFWriter writer) throws IOException, RDFHandlerException {
        }

        private void write(RDFWriter writer) throws IOException {
            try {
                this.handleBaseUri(writer);
                writer.startRDF();
                for (RdfNode node : this.model.findNodes(RdfType.NAMED_GRAPH)) {
                    Resource graph = (Resource)node;
                    for (Triple t : this.model.triples().g(graph).fetch()) {
                        writer.handleStatement(RdfIO.toStatement(graph, t));
                    }
                }
                writer.endRDF();
            }
            catch (RDFHandlerException e) {
                throw (IOException)new IOException().initCause(e);
            }
        }
    }

    public static class ModelWriterWithoutBase
    extends ModelWriterWithBase {
        private ModelWriterWithoutBase(Model model, RDFFormat format) {
            super(model, format);
        }

        public ModelWriterWithBase withBase(String baseUri) throws Uri.UriFormatException {
            return this.withBase(Uri.parse(baseUri));
        }

        public ModelWriterWithBase withBase(Uri baseUri) {
            Assert.notNull((Object)baseUri);
            return new ModelWriterWithBase(this.model, this.format, baseUri);
        }

        protected final void handleBaseUri(RDFWriter writer) {
        }
    }

    public static class InputWithBase {
        private final Reader in;
        private final Format format;
        private final Uri baseUri;
        private Uri targetNamedGraph;
        private BlankNodesPolicy blankNodesPolicy;

        private InputWithBase(Reader in, Format format, Uri baseUri) {
            this.in = in;
            this.format = format;
            this.baseUri = baseUri;
        }

        public void into(Model model) throws IOException {
            Assert.notNull((Object)model, (String)"Model");
            RDFParser parser = ((RDFParserFactory)RDFParserRegistry.getInstance().get((Object)this.format.toSesameFormat())).getParser();
            BlankNodesPolicy policy = this.blankNodesPolicy;
            if (policy == null) {
                policy = BlankNodesPolicy.globallyUnique();
            }
            parser.setPreserveBNodeIDs(true);
            parser.setValueFactory(policy.valueFactory());
            parser.setRDFHandler((RDFHandler)new ModelFeeder(model, this.targetNamedGraph));
            try {
                parser.parse(this.in, this.baseUri.toString());
            }
            catch (RDFParseException e) {
                throw (IOException)new IOException().initCause(e);
            }
            catch (RDFHandlerException e) {
                throw (IOException)new IOException().initCause(e);
            }
            this.in.close();
        }

        public InputWithBase withBlankNodesPolicy(BlankNodesPolicy blankNodesPolicy) {
            if (this.blankNodesPolicy != null) {
                throw new IllegalStateException("BlankNodesPolicy has already been set");
            }
            this.blankNodesPolicy = (BlankNodesPolicy)Preconditions.checkNotNull((Object)blankNodesPolicy);
            return this;
        }

        public InputWithBase withDefaultNamedGraph(String namedGraphUri) throws Uri.UriFormatException {
            return this.withDefaultNamedGraph(Uri.parse(namedGraphUri));
        }

        public InputWithBase withDefaultNamedGraph(Uri namedGraphUri) {
            if (this.targetNamedGraph != null) {
                throw new IllegalStateException("Default named graph has already been set");
            }
            this.targetNamedGraph = (Uri)Preconditions.checkNotNull((Object)namedGraphUri);
            return this;
        }
    }

    public static class InputWithoutBase {
        final Reader in;
        final Format format;

        private InputWithoutBase(Reader in, Format format) {
            this.in = in;
            this.format = format;
        }

        public InputWithBase withBase(String baseUri) throws Uri.UriFormatException {
            return this.withBase(Uri.parse(baseUri));
        }

        public InputWithBase withBase(Uri baseUri) {
            Assert.notNull((Object)baseUri, (String)"Base URI");
            return new InputWithBase(this.in, this.format, baseUri);
        }
    }
}

