/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2.labels;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import gr.forth.ics.graph.Direction;
import gr.forth.ics.graph.Graph;
import gr.forth.ics.graph.InspectableGraph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.swkm.model2.GraphUtils;
import gr.forth.ics.swkm.model2.Model;
import gr.forth.ics.swkm.model2.RdfNode;
import gr.forth.ics.swkm.model2.Triple;
import gr.forth.ics.swkm.model2.labels.Hierarchy;
import gr.forth.ics.swkm.model2.labels.Interval;
import gr.forth.ics.swkm.model2.labels.Label;
import gr.forth.ics.swkm.vocabulary.Rdf;
import gr.forth.ics.swkm.vocabulary.RdfSchema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHierarchy
implements Hierarchy {
    private final Graph graph;
    private Object LABEL_KEY = new Object();

    public AbstractHierarchy(Graph graph) {
        Assert.notNull((Object)graph);
        this.graph = graph;
    }

    private Collection<Node> explore(Node node, Direction direction) {
        Object visited = new Object();
        HashSet<Node> explored = new HashSet<Node>();
        LinkedList<Node> stack = new LinkedList<Node>();
        stack.add(node);
        while (!stack.isEmpty()) {
            Node currentNode = (Node)stack.remove();
            if (currentNode.has(visited)) continue;
            currentNode.putWeakly(visited, null);
            Collection<Node> nextNodes = this.exploreAdjacent(currentNode, direction);
            stack.addAll(nextNodes);
            explored.addAll(nextNodes);
        }
        return explored;
    }

    @Override
    public Collection<Node> exploreAncestors(Node node) {
        return this.explore(node, Direction.OUT);
    }

    @Override
    public Collection<Node> exploreDescendants(Node node) {
        return this.explore(node, Direction.IN);
    }

    @Override
    public Collection<Node> exploreDirectAncestors(Node node) {
        return this.exploreAdjacent(node, Direction.OUT);
    }

    @Override
    public Collection<Node> exploreDirectDescendants(Node node) {
        return this.exploreAdjacent(node, Direction.IN);
    }

    protected abstract Collection<Node> exploreAdjacent(Node var1, Direction var2);

    @Override
    public abstract Label getExistingLabelOf(Node var1);

    @Override
    public Label getLabelOf(Node node) {
        this.checkOwned(node);
        if (node.has(this.LABEL_KEY)) {
            return (Label)node.get(this.LABEL_KEY);
        }
        Label label = this.getExistingLabelOf(node);
        if (label == null) {
            label = Label.newEmpty();
        }
        node.putWeakly(this.LABEL_KEY, (Object)label.copy());
        return label;
    }

    protected void clearLabel(Node node) {
        node.remove(this.LABEL_KEY);
    }

    @Override
    public InspectableGraph exploredGraph() {
        return this.graph;
    }

    @Override
    public boolean isNew(Node node) {
        return this.getExistingLabelOf(node) == null;
    }

    @Override
    public void propagateInterval(Node node, Interval interval) {
        this.checkOwned(node);
        LinkedList<Node> stack = new LinkedList<Node>();
        stack.addLast(node);
        boolean direct = true;
        while (!stack.isEmpty()) {
            Node current = (Node)stack.removeLast();
            boolean changed = this.getLabelOf(current).addPropagatedLabel(interval, direct);
            direct = false;
            if (!changed) continue;
            for (Node ancestor : this.graph.adjacentNodes(current, Direction.OUT)) {
                stack.addLast(ancestor);
            }
        }
    }

    private void checkOwned(Node node) {
        if (!this.isOwned(node)) {
            if (node == null) {
                throw new IllegalArgumentException("null");
            }
            throw new IllegalArgumentException("Node: " + node + " is not in the graph of this hierarchy: [" + this.graph + "]");
        }
    }

    protected boolean isOwned(Node node) {
        return this.graph.containsNode(node);
    }

    public String toString() {
        return this.toString((InspectableGraph)this.graph);
    }

    protected String toString(InspectableGraph graph) {
        StringBuilder sb = new StringBuilder();
        sb.append("Nodes (").append(graph.nodeCount()).append(") :\n");
        for (Node node : graph.nodes()) {
            sb.append("    ").append(node).append(" (Label: ").append(this.getLabelOf(node)).append(")\n");
        }
        return sb.toString();
    }

    @Override
    public boolean hasUpdatedLabel(Node node) {
        Label existing = this.getExistingLabelOf(node);
        Label label = this.getLabelOf(node);
        return label.getTreeLabel().isEmpty() && label.equals(existing);
    }

    protected static Graph newClassHierarchyGraph(Model model) {
        GraphUtils.RdfGraph g = GraphUtils.toGraph(model, new Predicate<Triple>(){

            public boolean apply(Triple triple) {
                return triple.subject().type().isClass();
            }
        }, RdfSchema.SUBCLASSOF);
        if (g.graph().nodeCount() == 0) {
            return null;
        }
        g = AbstractHierarchy.createRootedGraph(g, model.mapResource(RdfSchema.RESOURCE));
        return g.graph();
    }

    protected static Graph newPropertyHierarchyGraph(Model model) {
        Graph g = GraphUtils.toGraph(model, RdfSchema.SUBPROPERTYOF).graph();
        if (g.nodeCount() == 0) {
            return null;
        }
        return g;
    }

    protected static Graph newMetaclassHierarchyGraph(Model model) {
        GraphUtils.RdfGraph g = GraphUtils.toGraph(model, new Predicate<Triple>(){

            public boolean apply(Triple triple) {
                return triple.subject().type().isMetaclass();
            }
        }, RdfSchema.SUBCLASSOF);
        if (g.graph().nodeCount() == 0) {
            return null;
        }
        g = AbstractHierarchy.createRootedGraph(g, model.mapResource(RdfSchema.CLASS));
        return g.graph();
    }

    protected static Graph newMetapropertyHierarchyGraph(Model model) {
        GraphUtils.RdfGraph g = GraphUtils.toGraph(model, new Predicate<Triple>(){

            public boolean apply(Triple triple) {
                return triple.subject().type().isMetaproperty();
            }
        }, RdfSchema.SUBCLASSOF);
        if (g.graph().nodeCount() == 0) {
            return null;
        }
        g = AbstractHierarchy.createRootedGraph(g, model.mapResource(Rdf.PROPERTY));
        return g.graph();
    }

    static GraphUtils.RdfGraph createRootedGraph(GraphUtils.RdfGraph graph, RdfNode rootRdfNode) {
        Map<RdfNode, Node> map = graph.nodeMap();
        Graph g = graph.graph();
        List<Node> subRoots = AbstractHierarchy.findRoots((InspectableGraph)g);
        Node root = map.get(rootRdfNode);
        if (root == null) {
            root = g.newNode((Object)rootRdfNode);
            map.put(rootRdfNode, root);
        }
        for (Node subRoot : subRoots) {
            if (subRoot == root) continue;
            g.newEdge(subRoot, root);
        }
        return new GraphUtils.RdfGraph(g, map);
    }

    protected static List<Node> findRoots(InspectableGraph graph) {
        ArrayList roots = Lists.newArrayList();
        for (Node n : graph.nodes()) {
            if (graph.outDegree(n) != 0) continue;
            roots.add(n);
        }
        return roots;
    }
}

