/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2.labels;

import gr.forth.ics.graph.Node;
import gr.forth.ics.swkm.model2.labels.Hierarchy;
import gr.forth.ics.swkm.model2.labels.Interval;
import gr.forth.ics.swkm.model2.labels.Label;
import gr.forth.ics.swkm.model2.labels.LabelException;
import gr.forth.ics.swkm.model2.labels.Labeler;
import gr.forth.ics.swkm.model2.labels.ProperAncInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BenderLabeler
implements Labeler {
    private final double T;
    private final long universeLength;
    public static final int maxNumOfHierarchies = 1999999;
    private static final Comparator<Interval> intervalComparator = new Comparator<Interval>(){

        @Override
        public int compare(Interval o1, Interval o2) {
            return o1.getPost() - o2.getPost();
        }
    };

    public BenderLabeler(double T) {
        this(T, 0x80000000L);
    }

    public BenderLabeler(double T, long universeLength) {
        if (T < 1.0 || T > 2.0) {
            throw new RuntimeException("T should lie in [1, 2]. It is found to be: " + T);
        }
        this.T = T;
        this.universeLength = universeLength;
    }

    @Override
    public void assignLabels(Hierarchy hierarchy) {
        this.assignLabels(hierarchy, true);
    }

    private void assignLabels(Hierarchy hierarchy, boolean sparse) {
        Collection<Node> rootsOfNewHierarchies = hierarchy.getNewRoots();
        this.fetchSiblings(hierarchy, rootsOfNewHierarchies);
        for (Node curRootOfNewHierarchy : rootsOfNewHierarchies) {
            ProperAncInfo properAncInfo = this.findProperAnc(curRootOfNewHierarchy, hierarchy);
            Node properAnc = properAncInfo.getProperAnc();
            Interval curAncMaxInterval = properAncInfo.getMaxInterval();
            int estimatedIntervalSize = this.fits(curRootOfNewHierarchy, curAncMaxInterval, this.T, hierarchy);
            if (properAnc == hierarchy.getRoot()) {
                estimatedIntervalSize = this.estimateIntervalSize(curRootOfNewHierarchy, this.T, hierarchy, true);
                Interval intervalOfNextHierarchy = this.getIntervalOfNextHierarchy(hierarchy, estimatedIntervalSize, false);
                this.overflowCheck(intervalOfNextHierarchy, hierarchy);
                this.labelHierarchy(curRootOfNewHierarchy, intervalOfNextHierarchy, hierarchy);
                continue;
            }
            if (estimatedIntervalSize >= 0) {
                Interval label = this.getProperSubInterval(curAncMaxInterval, estimatedIntervalSize);
                this.labelHierarchy(curRootOfNewHierarchy, label, hierarchy);
                continue;
            }
            Collection<Interval> parentTreeLabels = this.findParentTreeLabels(curRootOfNewHierarchy, hierarchy);
            hierarchy.exploreNodesIncludedIn(parentTreeLabels);
            HashSet<Node> relabeledClasses = this.relabelClasses(curRootOfNewHierarchy, properAnc, hierarchy);
            this.modifyPropagatedLabels(relabeledClasses, hierarchy);
            Interval freeRange = this.findMaxAvailableInterval(properAnc, hierarchy);
            estimatedIntervalSize = this.estimateIntervalSize(curRootOfNewHierarchy, this.T, hierarchy, true);
            Interval label = this.getProperSubInterval(freeRange, estimatedIntervalSize);
            this.labelHierarchy(curRootOfNewHierarchy, label, hierarchy);
        }
    }

    private Interval getProperSubInterval(Interval curAncMaxInterval, int estimatedIntervalSize) {
        return new Interval(curAncMaxInterval.getIndex(), curAncMaxInterval.getIndex() + estimatedIntervalSize);
    }

    private void changeNodeTreeLabel(Hierarchy hierarchy, Node n, int lengthOfNewHier) {
        Label nLabel = hierarchy.getLabelOf(n);
        Interval oldTreeLabel = nLabel.getTreeLabel();
        Interval newTreeLabel = new Interval(oldTreeLabel.getIndex(), oldTreeLabel.getPost() + lengthOfNewHier);
        nLabel.setTreeLabel(newTreeLabel);
    }

    private void modifyPropagatedLabels(HashSet<Node> relabeledClasses, Hierarchy hierarchy) {
        for (Node n : relabeledClasses) {
            Interval oldTreeLabel = hierarchy.getExistingLabelOf(n).getTreeLabel();
            Interval newTreeLabel = hierarchy.getLabelOf(n).getTreeLabel();
            Collection<Node> directAncs = hierarchy.exploreDirectAncestors(n);
            for (Node directAnc : directAncs) {
                Interval directAncTreeLabel = hierarchy.getLabelOf(directAnc).getTreeLabel();
                if (directAncTreeLabel.contains(oldTreeLabel)) continue;
                this.changePropagatedLabel(directAnc, oldTreeLabel, newTreeLabel, hierarchy, true);
            }
        }
    }

    private void changePropagatedLabel(Node n, Interval oldTreeLabel, Interval newTreeLabel, Hierarchy hierarchy, boolean direct) {
        Label label = hierarchy.getLabelOf(n);
        boolean existed = label.removePropagatedLabel(oldTreeLabel, direct);
        if (existed) {
            label.addPropagatedLabel(newTreeLabel, direct);
        }
        for (Node anc : hierarchy.exploreAncestors(n)) {
            this.changePropagatedLabel(anc, oldTreeLabel, newTreeLabel, hierarchy, false);
        }
    }

    private void overflowCheck(Interval intervalOfNextHierarchy, Hierarchy hierarchy) {
        if (hierarchy.getRoot() == null || intervalOfNextHierarchy.getPost() < hierarchy.getLabelOf(hierarchy.getRoot()).getTreeLabel().getPost()) {
            return;
        }
        this.relabelAll(hierarchy);
    }

    private void relabelAll(Hierarchy hierarchy) {
        hierarchy.exploreEverythingAsNew();
        this.assignLabels(hierarchy, false);
    }

    private HashSet<Node> relabelClasses(Node root, Node parent, Hierarchy hierarchy) {
        HashSet<Node> relabeledClasses = new HashSet<Node>();
        Node wholeRoot = hierarchy.getRoot();
        Collection<Node> directDescsOfWholeHierarchy = hierarchy.exploreDirectDescendants(wholeRoot);
        int freeGapNeededSparse = this.estimateIntervalSize(root, this.T, hierarchy, true);
        int freeGapNeededDense = this.estimateIntervalSize(root, this.T, hierarchy, false);
        Node properAnc = this.findAncestorWithProperFreeGap(root, parent, hierarchy, freeGapNeededSparse, freeGapNeededDense, directDescsOfWholeHierarchy);
        int properGapNeeded = 0;
        properGapNeeded = directDescsOfWholeHierarchy.contains(properAnc) ? freeGapNeededDense : freeGapNeededSparse;
        this.relabelClass(parent, hierarchy, properGapNeeded, relabeledClasses);
        return relabeledClasses;
    }

    private void relabelClass(Node n, Hierarchy hierarchy, int lengthOfNewHier, HashSet<Node> relabeledClasses) {
        relabeledClasses.add(n);
        this.changeNodeTreeLabel(hierarchy, n, lengthOfNewHier);
        Node directAnc = this.findSpanTreeDirectAnc(n, hierarchy);
        Collection<Node> siblings = this.findSiblingsNext(n, directAnc, hierarchy);
        this.moveSiblings(n, siblings, hierarchy, lengthOfNewHier);
        Node spanTreeDirectAnc = this.findSpanTreeDirectAnc(n, hierarchy);
        if (spanTreeDirectAnc != hierarchy.getRoot()) {
            this.relabelClass(spanTreeDirectAnc, hierarchy, lengthOfNewHier, relabeledClasses);
        }
    }

    private void moveSiblings(Node n, Collection<Node> siblings, Hierarchy hierarchy, int lengthOfNewHier) {
        for (Node sibling : siblings) {
            if (sibling == n) continue;
            this.moveLabelRight(sibling, hierarchy, lengthOfNewHier);
            Collection<Node> descs = hierarchy.exploreDescendants(sibling);
            Interval siblingTreeLabel = hierarchy.getExistingLabelOf(sibling).getTreeLabel();
            for (Node desc : descs) {
                Interval descTreeLabel = hierarchy.getExistingLabelOf(desc).getTreeLabel();
                if (!siblingTreeLabel.contains(descTreeLabel)) continue;
                this.moveLabelRight(desc, hierarchy, lengthOfNewHier);
            }
        }
    }

    private void moveLabelRight(Node n, Hierarchy hierarchy, int lengthOfNewHier) {
        Label label = hierarchy.getLabelOf(n);
        Interval oldTreeLabel = label.getTreeLabel();
        Interval newTreeLabel = new Interval(oldTreeLabel.getIndex() + lengthOfNewHier, oldTreeLabel.getPost() + lengthOfNewHier);
        label.setTreeLabel(newTreeLabel);
    }

    private Collection<Node> findSiblingsNext(Node n, Node directAnc, Hierarchy hierarchy) {
        HashSet<Node> siblingsNextN = new HashSet<Node>();
        Collection<Node> siblings = hierarchy.exploreDirectDescendants(directAnc);
        Interval nTreeInterval = hierarchy.getExistingLabelOf(n).getTreeLabel();
        Interval directAncTreeInterval = hierarchy.getExistingLabelOf(directAnc).getTreeLabel();
        for (Node sibling : siblings) {
            Interval siblingTreeInterval;
            Label existingLabelOfSibling;
            if (sibling == n || (existingLabelOfSibling = hierarchy.getExistingLabelOf(sibling)) == null || !directAncTreeInterval.contains(siblingTreeInterval = existingLabelOfSibling.getTreeLabel()) || nTreeInterval.getPost() >= siblingTreeInterval.getPost()) continue;
            siblingsNextN.add(sibling);
        }
        return siblingsNextN;
    }

    private Node findAncestorWithProperFreeGap(Node n, Node parent, Hierarchy hierarchy, int freeGapNeededSparse, int freeGapNeededDense, Collection<Node> directDescsOfWholeHierarchy) {
        Node spanTreeDirectAnc = null;
        spanTreeDirectAnc = parent != null ? parent : this.findSpanTreeDirectAnc(n, hierarchy);
        int freeGap = this.findMaxAvailableInterval(spanTreeDirectAnc, hierarchy).length();
        int properGapNeeded = 0;
        properGapNeeded = directDescsOfWholeHierarchy.contains(n) ? freeGapNeededDense : freeGapNeededSparse;
        if (freeGap >= properGapNeeded) {
            return spanTreeDirectAnc;
        }
        return this.findAncestorWithProperFreeGap(spanTreeDirectAnc, null, hierarchy, freeGapNeededSparse, freeGapNeededDense, directDescsOfWholeHierarchy);
    }

    private Node findSpanTreeDirectAnc(Node n, Hierarchy hierarchy) {
        Collection<Node> directAncs = hierarchy.exploreDirectAncestors(n);
        Interval nTreeInterval = hierarchy.getExistingLabelOf(n).getTreeLabel();
        for (Node directAnc : directAncs) {
            Interval directAncTreeInterval = hierarchy.getExistingLabelOf(directAnc).getTreeLabel();
            if (!directAncTreeInterval.contains(nTreeInterval)) continue;
            return directAnc;
        }
        return null;
    }

    private Collection<Interval> findParentTreeLabels(Node curRootOfNewHierarchy, Hierarchy hierarchy) {
        HashSet<Interval> parentTreeLabels = new HashSet<Interval>();
        Collection<Node> parents = hierarchy.exploreDirectAncestors(curRootOfNewHierarchy);
        for (Node parent : parents) {
            Interval parentTreeLabel = hierarchy.getExistingLabelOf(parent).getTreeLabel();
            if (parentTreeLabel == null) continue;
            parentTreeLabels.add(parentTreeLabel);
        }
        return parentTreeLabels;
    }

    private Collection<Node> orderAccordingToDescNum(Collection<Node> col, Hierarchy hierarchy) {
        TreeMap numToElems = new TreeMap(Collections.reverseOrder());
        for (Node c : col) {
            int numOfDescs = hierarchy.exploreDescendants(c).size();
            ArrayList<Node> elements = (ArrayList<Node>)numToElems.get(numOfDescs);
            if (elements == null) {
                elements = new ArrayList<Node>(numOfDescs);
            }
            elements.add(c);
            numToElems.put(numOfDescs, elements);
        }
        ArrayList<Node> ordered = new ArrayList<Node>(col.size());
        for (ArrayList elems : numToElems.values()) {
            ordered.addAll(elems);
        }
        return ordered;
    }

    private Collection<Node> notVisitedDescs(Node n, Hierarchy hierarchy) {
        ArrayList<Node> notVisitedDescs = new ArrayList<Node>();
        Collection<Node> descs = hierarchy.exploreDescendants(n);
        for (Node d : descs) {
            if (!hierarchy.getLabelOf(d).getTreeLabel().isEmpty()) continue;
            notVisitedDescs.add(d);
        }
        return notVisitedDescs;
    }

    private boolean labelClass(Node c, Stack<Node> encountered, Hierarchy hierarchy, int step, int index) {
        encountered.add(c);
        Collection<Node> directDescs = hierarchy.exploreDirectDescendants(c);
        Collection<Node> orderDirectDescs = this.orderAccordingToDescNum(directDescs, hierarchy);
        Collection<Node> notVisitedDescs = this.notVisitedDescs(c, hierarchy);
        Interval interval = new Interval(index, index + (notVisitedDescs.size() + 1) * step - 1);
        boolean oldExisted = this.assignLabelClass(c, interval, hierarchy);
        if (oldExisted) {
            return true;
        }
        Node prevSibling = null;
        for (Node desc : orderDirectDescs) {
            boolean existed;
            if (this.transitiveEdge(desc, c, hierarchy)) continue;
            int properIndex = 0;
            if (prevSibling == null) {
                properIndex = index;
            } else {
                Interval prevTreeLabel = hierarchy.getLabelOf(prevSibling).getTreeLabel();
                properIndex = prevTreeLabel.getPost() + 1;
            }
            if (existed = this.labelClass(desc, encountered, hierarchy, step, properIndex)) continue;
            prevSibling = desc;
        }
        return false;
    }

    private void labelHierarchy(Node c, Interval availableInterval, Hierarchy hierarchy) {
        int step = availableInterval.length() / (hierarchy.exploreDescendants(c).size() + 1);
        this.labelClass(c, new Stack<Node>(), hierarchy, step, availableInterval.getIndex());
        hierarchy.recalculateIndexForNewHierarchy();
    }

    private boolean assignLabelClass(Node c, Interval interval, Hierarchy hierarchy) {
        if (interval.isEmpty()) {
            throw new LabelException("Hierarchy too deep to handle; attempted to assign an empty label");
        }
        boolean oldExisted = false;
        Label cLabel = hierarchy.getLabelOf(c);
        if (!cLabel.getTreeLabel().isEmpty()) {
            this.propagateLabel(c, hierarchy);
            oldExisted = true;
        } else {
            for (Node parent : hierarchy.exploreDirectAncestors(c)) {
                if (!interval.equals(hierarchy.getLabelOf(parent).getTreeLabel())) continue;
                throw new LabelException("Hierarchy too deep to handle; attempted to assign the same label to a parent and to its kid");
            }
            cLabel.setTreeLabel(interval);
            Collection<Node> directAncs = hierarchy.exploreDirectAncestors(c);
            int count = 0;
            for (Node directAnc : directAncs) {
                if (hierarchy.getLabelOf(directAnc).getTreeLabel().isEmpty()) continue;
                ++count;
            }
            if (count >= 1) {
                this.propagateLabel(c, hierarchy);
            }
        }
        return oldExisted;
    }

    private void propagateLabel(Node c, Hierarchy hierarchy) {
        Interval interval = hierarchy.getLabelOf(c).getTreeLabel();
        Collection<Node> directAnc = hierarchy.exploreDirectAncestors(c);
        Collection<Node> anc = hierarchy.exploreAncestors(c);
        for (Node curAnc : anc) {
            Label curAncLabel = hierarchy.getLabelOf(curAnc);
            if (!hierarchy.isNew(curAnc) && curAncLabel.getTreeLabel().contains(interval)) continue;
            if (directAnc.contains(curAnc)) {
                curAncLabel.addPropagatedLabel(interval, true);
                continue;
            }
            curAncLabel.addPropagatedLabel(interval, false);
        }
    }

    private boolean transitiveEdge(Node desc, Node anc, Hierarchy hierarchy) {
        Collection<Node> directDescs = hierarchy.exploreDirectDescendants(anc);
        for (Node n : directDescs) {
            Collection<Node> nDescs = hierarchy.exploreDescendants(n);
            if (!nDescs.contains(desc)) continue;
            return true;
        }
        return false;
    }

    private Interval getIntervalOfNextHierarchy(Hierarchy hierarchy, int estimatedIntervalSize, boolean sparse) {
        int intervalLengthPerHier = (int)(this.universeLength / 1999999L);
        int index = hierarchy.getIndexForNewHierarchy();
        if (sparse) {
            return new Interval(index, index + intervalLengthPerHier);
        }
        return new Interval(index, index + estimatedIntervalSize);
    }

    private int fits(Node c, Interval interval, double T, Hierarchy hierarchy) {
        int estimatedIntervalSize = this.estimateIntervalSize(c, T, hierarchy, true);
        if (interval.length() >= estimatedIntervalSize) {
            return estimatedIntervalSize;
        }
        return -1;
    }

    private int estimateIntervalSize(Node c, double T, Hierarchy hierarchy, boolean sparse) {
        if (sparse) {
            return (int)(T * 20.0 * (double)(hierarchy.exploreDescendants(c).size() + 2)) + 1;
        }
        return 2 * (hierarchy.exploreDescendants(c).size() + 2) + 1;
    }

    private ProperAncInfo findProperAnc(Node curRootOfNewHierarchy, Hierarchy hierarchy) {
        Collection<Node> ancestorsOfCurRoot = hierarchy.exploreDirectAncestors(curRootOfNewHierarchy);
        Node properAnc = null;
        Interval maxInterval = new Interval(0, -2);
        for (Node curAnc : ancestorsOfCurRoot) {
            Interval curAncMaxInterval = this.findMaxAvailableInterval(curAnc, hierarchy);
            properAnc = curAnc;
            if (curAncMaxInterval.length() <= maxInterval.length()) continue;
            maxInterval = curAncMaxInterval;
        }
        ProperAncInfo properAncInfo = new ProperAncInfo(properAnc, maxInterval);
        return properAncInfo;
    }

    private Interval findMaxAvailableInterval(Node curAnc, Hierarchy hierarchy) {
        int freeIntervalLength;
        Interval properInterval = null;
        int max = 0;
        Interval curAncTreeInterval = hierarchy.getLabelOf(curAnc).getTreeLabel();
        Collection<Node> descs = hierarchy.exploreDirectDescendants(curAnc);
        TreeSet<Interval> orderedDescTreeIntervals = new TreeSet<Interval>(intervalComparator);
        for (Node desc : descs) {
            Interval curDescTreeInterval = hierarchy.getLabelOf(desc).getTreeLabel();
            if (curDescTreeInterval.isEmpty() || !curAncTreeInterval.contains(curDescTreeInterval)) continue;
            orderedDescTreeIntervals.add(curDescTreeInterval);
        }
        Interval prev = null;
        for (Interval cur : orderedDescTreeIntervals) {
            if (prev == null) {
                prev = cur;
                continue;
            }
            int freeIntervalLength2 = cur.getIndex() - 1 - (prev.getPost() + 1);
            if (freeIntervalLength2 > max) {
                properInterval = new Interval(prev.getPost() + 1, cur.getIndex() - 1);
                max = freeIntervalLength2;
            }
            prev = cur;
        }
        if (prev != null && (freeIntervalLength = curAncTreeInterval.getPost() - 1 - (prev.getPost() + 1)) > max) {
            properInterval = new Interval(prev.getPost() + 1, curAncTreeInterval.getPost() - 1);
            max = freeIntervalLength;
        }
        if (properInterval == null) {
            properInterval = orderedDescTreeIntervals.size() == 0 ? new Interval(curAncTreeInterval.getIndex(), curAncTreeInterval.getPost() - 1) : new Interval(orderedDescTreeIntervals.last().getPost() + 1, curAncTreeInterval.getPost() - 1);
        }
        return properInterval;
    }

    private void fetchSiblings(Hierarchy hierarchy, Collection<Node> rootsOfNewHierarchies) {
        HashSet<Interval> siblingsIntervals = new HashSet<Interval>();
        for (Node r : rootsOfNewHierarchies) {
            Collection<Node> ancs = hierarchy.exploreAncestors(r);
            for (Node anc : ancs) {
                if (hierarchy.isNew(anc)) continue;
                Label label = hierarchy.getExistingLabelOf(anc);
                siblingsIntervals.add(label.getTreeLabel());
            }
        }
        hierarchy.exploreNodesIncludedIn(siblingsIntervals);
    }
}

