/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2.labels;

import gr.forth.ics.swkm.model2.labels.Interval;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompoundInterval {
    private Set<Interval> intervals = new LinkedHashSet<Interval>();

    public CompoundInterval() {
    }

    public CompoundInterval(Interval interval) {
        this.add(interval);
    }

    public CompoundInterval(Iterable<Interval> intervals) {
        for (Interval interval : intervals) {
            this.add(interval);
        }
    }

    public CompoundInterval(CompoundInterval copy) {
        this.add(copy);
    }

    public void set(Interval interval) {
        this.clear();
        if (interval != null && !interval.isEmpty()) {
            this.intervals.add(interval);
        }
    }

    public boolean add(CompoundInterval newIntervals) {
        Assert.notNull((Object)newIntervals);
        boolean changed = false;
        for (Interval interval : newIntervals.getIntervals()) {
            changed |= this.add(interval);
        }
        return changed;
    }

    public boolean add(Interval newInterval) {
        Assert.notNull((Object)newInterval);
        if (newInterval.isEmpty()) {
            return false;
        }
        return this.intervals.add(newInterval);
    }

    public boolean remove(Interval removedInterval) {
        return this.intervals.remove(removedInterval);
    }

    public boolean contains(int point) {
        for (Interval current : this.intervals) {
            if (!current.contains(point)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Interval interval) {
        Assert.notNull((Object)interval);
        for (Interval current : this.intervals) {
            if (!current.contains(interval)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(CompoundInterval compoundInterval) {
        Assert.notNull((Object)compoundInterval);
        for (Interval interval : compoundInterval.getIntervals()) {
            if (this.contains(interval)) continue;
            return false;
        }
        return true;
    }

    public boolean overlapsWith(CompoundInterval compoundInterval) {
        Assert.notNull((Object)compoundInterval);
        for (Interval interval : compoundInterval.getIntervals()) {
            if (!this.overlapsWith(interval)) continue;
            return true;
        }
        return false;
    }

    public boolean overlapsWith(Interval interval) {
        Assert.notNull((Object)interval);
        for (Interval ownInterval : this.getIntervals()) {
            if (!ownInterval.overlapsWith(interval)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.intervals.toString();
    }

    public Set<Interval> getIntervals() {
        return Collections.unmodifiableSet(this.intervals);
    }

    public boolean isEmpty() {
        return this.intervals.isEmpty();
    }

    public void clear() {
        this.intervals.clear();
    }

    public Interval maxInterval() {
        if (this.isEmpty()) {
            return Interval.empty();
        }
        Interval max = null;
        for (Interval interval : this.intervals) {
            if (max != null && max.length() >= interval.length()) continue;
            max = interval;
        }
        return max;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CompoundInterval)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        CompoundInterval other = (CompoundInterval)obj;
        return ((Object)this.intervals).equals(other.intervals);
    }

    public int hashCode() {
        return ((Object)this.intervals).hashCode();
    }
}

