/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2.labels;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import gr.forth.ics.graph.Direction;
import gr.forth.ics.graph.Edge;
import gr.forth.ics.graph.Graph;
import gr.forth.ics.graph.InspectableGraph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.algo.Orders;
import gr.forth.ics.graph.util.InvertedInspectableGraph;
import gr.forth.ics.swkm.model2.Model;
import gr.forth.ics.swkm.model2.labels.AbstractHierarchy;
import gr.forth.ics.swkm.model2.labels.Interval;
import gr.forth.ics.swkm.model2.labels.Label;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainMemoryHierarchy
extends AbstractHierarchy {
    private final Object existingLabelKey = new Object();
    private final Node root;
    private int nextIndex;

    public MainMemoryHierarchy(Graph graph) {
        super(graph);
        List<Node> roots = MainMemoryHierarchy.findRoots((InspectableGraph)graph);
        if (roots.isEmpty()) {
            throw new IllegalArgumentException("No root node found for graph: " + graph);
        }
        if (roots.size() > 1) {
            this.root = null;
        } else {
            this.root = roots.get(0);
            this.root.putWeakly(this.existingLabelKey, (Object)new Label(new Interval(0, Integer.MAX_VALUE)));
        }
        this.recalculateIndexForNewHierarchy();
    }

    @Override
    protected Collection<Node> exploreAdjacent(Node node, Direction direction) {
        ArrayList nodes = Lists.newArrayListWithExpectedSize((int)this.exploredGraph().degree(node, direction));
        for (Edge e : this.exploredGraph().edges(node, direction)) {
            nodes.add(e.opposite(node));
        }
        return nodes;
    }

    @Override
    public Label getExistingLabelOf(Node node) {
        return (Label)node.get(this.existingLabelKey);
    }

    @Override
    public Node getRoot() {
        return this.root;
    }

    @Override
    public Collection<Node> exploreNodesIncludedIn(Collection<Interval> ranges) {
        ArrayList nodes = Lists.newArrayList();
        for (Node n : this.exploredGraph().nodes()) {
            Label label = this.getLabelOf(n);
            for (Interval range : ranges) {
                if (!label.getTreeLabel().contains(range)) continue;
                nodes.add(n);
            }
        }
        return nodes;
    }

    @Override
    public Collection<Node> getNewRoots() {
        HashSet newRoots = Sets.newHashSet();
        InspectableGraph g = this.exploredGraph();
        List topo = Orders.topological((InspectableGraph)new InvertedInspectableGraph(g));
        for (Node n : topo) {
            if (!this.isNew(n)) continue;
            boolean hasNewRootParent = false;
            for (Node parent : g.adjacentNodes(n, Direction.OUT)) {
                if (!this.isNew(parent)) continue;
                hasNewRootParent = true;
            }
            if (hasNewRootParent) continue;
            newRoots.add(n);
        }
        return newRoots;
    }

    @Override
    public int getIndexForNewHierarchy() {
        return this.nextIndex;
    }

    @Override
    public final void recalculateIndexForNewHierarchy() {
        this.nextIndex = 0;
        for (Node n : this.exploredGraph().nodes()) {
            Label label = this.getLabelOf(n);
            this.nextIndex = Math.max(this.nextIndex, label.getTreeLabel().getPost() + 1);
        }
    }

    @Override
    public void exploreEverythingAsNew() {
        for (Node n : this.exploredGraph().nodes()) {
            this.clearLabel(n);
        }
    }

    static MainMemoryHierarchy newMetaclassHierarchy(Model model) {
        Graph g = MainMemoryHierarchy.newMetaclassHierarchyGraph(model);
        if (g == null) {
            return null;
        }
        return new MainMemoryHierarchy(g);
    }

    static MainMemoryHierarchy newMetapropertyHierarchy(Model model) {
        Graph g = MainMemoryHierarchy.newMetapropertyHierarchyGraph(model);
        if (g == null) {
            return null;
        }
        return new MainMemoryHierarchy(g);
    }

    static MainMemoryHierarchy newClassHierarchy(Model model) {
        Graph g = MainMemoryHierarchy.newClassHierarchyGraph(model);
        if (g == null) {
            return null;
        }
        return new MainMemoryHierarchy(g);
    }

    static MainMemoryHierarchy newPropertyHierarchy(Model model) {
        Graph g = MainMemoryHierarchy.newPropertyHierarchyGraph(model);
        if (g == null) {
            return null;
        }
        return new MainMemoryHierarchy(g);
    }
}

