/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2.labels;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import gr.forth.ics.swkm.model2.Uri;
import gr.forth.ics.swkm.model2.labels.Label;
import gr.forth.ics.swkm.vocabulary.Rdf;
import gr.forth.ics.swkm.vocabulary.RdfSchema;
import gr.forth.ics.swkm.vocabulary.XmlSchema;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PredefinedLabels {
    private static final PredefinedLabels swkmPredefinedLabels = PredefinedLabels.fromUriMap((Map<Uri, Label>)ImmutableMap.builder().put((Object)RdfSchema.LITERAL, (Object)Label.create(12, 12)).put((Object)XmlSchema.NOTATION, (Object)Label.create(52, 52)).put((Object)XmlSchema.NAME, (Object)Label.create(58, 58)).put((Object)XmlSchema.QNAME, (Object)Label.create(51, 51)).put((Object)XmlSchema.STRING, (Object)Label.create(30, 30)).put((Object)XmlSchema.TIME, (Object)Label.create(41, 41)).put((Object)XmlSchema.TOKEN, (Object)Label.create(54, 54)).put((Object)XmlSchema.ANY_URI, (Object)Label.create(50, 50)).put((Object)XmlSchema.BASE64_BINARY, (Object)Label.create(49, 49)).put((Object)XmlSchema.BOOLEAN, (Object)Label.create(33, 33)).put((Object)XmlSchema.BYTE, (Object)Label.create(70, 70)).put((Object)XmlSchema.DATE, (Object)Label.create(42, 42)).put((Object)XmlSchema.DATETIME, (Object)Label.create(34, 34)).put((Object)XmlSchema.DECIMAL, (Object)Label.create(38, 38)).put((Object)XmlSchema.DOUBLE, (Object)Label.create(39, 39)).put((Object)XmlSchema.DURATION, (Object)Label.create(40, 40)).put((Object)XmlSchema.FLOAT, (Object)Label.create(32, 32)).put((Object)XmlSchema.GDAY, (Object)Label.create(46, 46)).put((Object)XmlSchema.GMONTH, (Object)Label.create(47, 47)).put((Object)XmlSchema.GMONTH_DAY, (Object)Label.create(45, 45)).put((Object)XmlSchema.GYEAR, (Object)Label.create(44, 44)).put((Object)XmlSchema.ENTITIES, (Object)Label.create(64, 64)).put((Object)XmlSchema.ENTITY, (Object)Label.create(63, 63)).put((Object)XmlSchema.ID, (Object)Label.create(60, 60)).put((Object)XmlSchema.IDREF, (Object)Label.create(61, 61)).put((Object)XmlSchema.IDREFS, (Object)Label.create(62, 62)).put((Object)XmlSchema.NCNAME, (Object)Label.create(59, 59)).put((Object)XmlSchema.NMTOKEN, (Object)Label.create(56, 56)).put((Object)XmlSchema.NMTOKENS, (Object)Label.create(57, 57)).put((Object)XmlSchema.GYEAR_MONTH, (Object)Label.create(43, 43)).put((Object)XmlSchema.HEX_BINARY, (Object)Label.create(48, 48)).put((Object)XmlSchema.INT, (Object)Label.create(68, 68)).put((Object)XmlSchema.INTEGER, (Object)Label.create(31, 31)).put((Object)XmlSchema.LANGUAGE, (Object)Label.create(55, 55)).put((Object)XmlSchema.LONG, (Object)Label.create(67, 67)).put((Object)XmlSchema.NEGATIVE_INTEGER, (Object)Label.create(66, 66)).put((Object)XmlSchema.NON_NEGATIVE_INTEGER, (Object)Label.create(71, 71)).put((Object)XmlSchema.NON_POSITIVE_INTEGER, (Object)Label.create(65, 65)).put((Object)XmlSchema.NORMALIZED_STRING, (Object)Label.create(53, 53)).put((Object)XmlSchema.POSITIVE_INTEGER, (Object)Label.create(76, 76)).put((Object)XmlSchema.SHORT, (Object)Label.create(69, 69)).put((Object)XmlSchema.UNSIGNED_LONG, (Object)Label.create(72, 72)).put((Object)XmlSchema.UNSIGNED_INT, (Object)Label.create(73, 73)).put((Object)XmlSchema.UNSIGNED_SHORT, (Object)Label.create(74, 74)).put((Object)XmlSchema.UNSIGNED_BYTE, (Object)Label.create(75, 75)).put((Object)RdfSchema.CLASS, (Object)Label.create(300, 1000000000)).put((Object)Rdf.PROPERTY, (Object)Label.create(2000000001, 2000000000)).put((Object)RdfSchema.RESOURCE, (Object)Label.create(300, 2000000000)).build());

    public abstract Label predefinedLabelOf(Uri var1);

    public abstract Set<Uri> getResourcesWithPredefinedLabels();

    public static PredefinedLabels fromUriMap(Map<Uri, Label> uriToLabelMap) {
        return new MapBasedPredefinedLabels(uriToLabelMap);
    }

    public PredefinedLabels merge(PredefinedLabels otherPredefinedLabels) {
        Preconditions.checkNotNull((Object)otherPredefinedLabels);
        return new CompositePredefinedLabels(this, otherPredefinedLabels);
    }

    public static PredefinedLabels swkmPredefinedLabels() {
        return swkmPredefinedLabels;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompositePredefinedLabels
    extends PredefinedLabels {
        private final PredefinedLabels first;
        private final PredefinedLabels second;

        CompositePredefinedLabels(PredefinedLabels first, PredefinedLabels second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public Label predefinedLabelOf(Uri resourceURI) {
            Label label = this.second.predefinedLabelOf(resourceURI);
            if (label == null) {
                label = this.first.predefinedLabelOf(resourceURI);
            }
            return label;
        }

        @Override
        public Set<Uri> getResourcesWithPredefinedLabels() {
            return Sets.union(this.first.getResourcesWithPredefinedLabels(), this.second.getResourcesWithPredefinedLabels());
        }

        public String toString() {
            return "[" + this.first + ", " + this.second + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapBasedPredefinedLabels
    extends PredefinedLabels {
        final Map<Uri, Label> immutablePredefinedLabels;

        public MapBasedPredefinedLabels(Map<Uri, Label> uriToLabelMap) {
            this.immutablePredefinedLabels = ImmutableMap.copyOf(uriToLabelMap);
        }

        @Override
        public Label predefinedLabelOf(Uri resourceUri) {
            return this.immutablePredefinedLabels.get(resourceUri);
        }

        @Override
        public Set<Uri> getResourcesWithPredefinedLabels() {
            return this.immutablePredefinedLabels.keySet();
        }

        public String toString() {
            return this.immutablePredefinedLabels.toString();
        }
    }
}

