/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2.validation;

import com.google.common.base.Join;
import gr.forth.ics.graph.path.Path;
import gr.forth.ics.swkm.model2.Literal;
import gr.forth.ics.swkm.model2.Resource;
import gr.forth.ics.swkm.model2.Triple;
import gr.forth.ics.swkm.model2.validation.ValidationProblem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ErrorCode {
    NO_DOMAIN,
    NO_RANGE,
    NON_UNIQUE_DOMAIN,
    NON_UNIQUE_RANGE,
    ILLEGAL_DOMAIN,
    CYCLE_IN_SUBCLASSOF,
    CYCLE_IN_SUBPROPERTYOF,
    INCOMPATIBLE_DOMAIN,
    INCOMPATIBLE_RANGE,
    WRONGLY_TYPED_NODE,
    WRONGLY_TYPED_LITERAL,
    ILLEGAL_TRIPLE,
    ILLEGAL_LITERAL;


    public static ValidationProblem nonUniquePropertyDomain(Resource property, Iterable<?> domains) {
        return ValidationProblem.error("Property: " + property + " has more than one domains: " + Join.join((String)",", domains), NON_UNIQUE_DOMAIN);
    }

    public static ValidationProblem nonUniquePropertyRange(Resource property, Iterable<?> ranges) {
        return ValidationProblem.error("Property: " + property + " has more than one ranges: " + Join.join((String)",", ranges), NON_UNIQUE_RANGE);
    }

    public static ValidationProblem illegalDomain(Resource property, Resource domain) {
        return ValidationProblem.error("Property " + property + " defines a domain that is not allowed: " + domain, ILLEGAL_DOMAIN);
    }

    public static ValidationProblem cycleInSubclassOf(Path cycle) {
        return ValidationProblem.error("Cycle in rdfs:subClassOf relation: " + cycle, CYCLE_IN_SUBCLASSOF);
    }

    public static ValidationProblem cycleInSubpropertyOf(Path cycle) {
        return ValidationProblem.error("Cycle in rdfs:subPropertyOf relation: " + cycle, CYCLE_IN_SUBPROPERTYOF);
    }

    public static ValidationProblem incompatibleDomain(Resource subProperty, Resource subDomain, Resource superProperty, Resource superDomain) {
        return ValidationProblem.error("Subproperty: " + subProperty + " has domain: " + subDomain + " which is not a descendant of the domain: " + superDomain + " of the superproperty: " + superProperty, INCOMPATIBLE_DOMAIN);
    }

    public static ValidationProblem incompatibleRange(Resource subProperty, Resource subRange, Resource superProperty, Resource superRange) {
        return ValidationProblem.error("Subproperty: " + subProperty + " has range: " + subRange + "which is not a descendant of the range: " + superRange + " of the superproperty: " + superProperty, INCOMPATIBLE_RANGE);
    }

    public static ValidationProblem wronglyTypedSubject(Triple propertyInstance, Resource domain) {
        return ValidationProblem.error("Property instance: " + propertyInstance + " has subject which is not " + "a type of: " + domain + ", which is the declared domain of the property", WRONGLY_TYPED_NODE);
    }

    public static ValidationProblem wronglyTypedObject(Triple propertyInstance, Resource range) {
        return ValidationProblem.error("Property instance: " + propertyInstance + " has object which is not " + "a type of: " + range + ", which is the declared range of the property", WRONGLY_TYPED_NODE);
    }

    public static ValidationProblem wronglyTypedLiteral(Triple propertyInstance, Resource range) {
        return ValidationProblem.error("Property instance: " + propertyInstance + " has a literal object which does not " + "match with the type of: " + range + ", which is the declared range of the property. Either the literal " + "is untyped and the range is not rdfs:Literal, or it is typed and is different with the range", WRONGLY_TYPED_LITERAL);
    }

    public static ValidationProblem noDomain(Resource property) {
        return ValidationProblem.warning("No domain defined for " + property, NO_DOMAIN);
    }

    public static ValidationProblem noRange(Resource property) {
        return ValidationProblem.warning("No range defined for " + property, NO_RANGE);
    }

    public static ValidationProblem illegalTriple(Triple triple, String explanation) {
        return ValidationProblem.error(explanation, ILLEGAL_TRIPLE);
    }

    public static ValidationProblem illegalLiteral(Literal literal) {
        return ValidationProblem.error("Literal: " + literal + " is not legal according to its type", ILLEGAL_LITERAL);
    }
}

