/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2.validation;

import com.google.common.collect.Lists;
import gr.forth.ics.swkm.model2.validation.ValidationException;
import gr.forth.ics.swkm.model2.validation.ValidationHandler;
import gr.forth.ics.swkm.model2.validation.ValidationProblem;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProblemCollector
implements ValidationHandler {
    private final List<ValidationProblem> errors = Lists.newArrayList();
    private final List<ValidationProblem> warnings = Lists.newArrayList();

    @Override
    public void handleError(ValidationProblem error) {
        this.errors.add(error);
    }

    @Override
    public void handleWarning(ValidationProblem warning) {
        this.warnings.add(warning);
    }

    public List<ValidationProblem> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public List<ValidationProblem> getWarnings() {
        return Collections.unmodifiableList(this.warnings);
    }

    public void checkNoError() throws ValidationException {
        if (!this.errors.isEmpty()) {
            throw new ValidationException(this.errors, this.warnings);
        }
    }

    public void checkNoErrorOrWarning() {
        if (!this.errors.isEmpty() || !this.warnings.isEmpty()) {
            throw new ValidationException(this.errors, this.warnings);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.errors.isEmpty()) {
            sb.append("Errors: \n");
            for (ValidationProblem problem : this.errors) {
                sb.append("    ").append(problem).append("\n");
            }
        }
        if (!this.warnings.isEmpty()) {
            sb.append("Warnings: \n");
            for (ValidationProblem problem : this.errors) {
                sb.append("    ").append(problem).append("\n");
            }
        }
        if (this.errors.isEmpty() && this.warnings.isEmpty()) {
            sb.append("(No errors or warnings)");
        }
        return sb.toString();
    }
}

