/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2.validation;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import gr.forth.ics.graph.Graph;
import gr.forth.ics.graph.InspectableGraph;
import gr.forth.ics.graph.path.Cycles;
import gr.forth.ics.graph.path.Path;
import gr.forth.ics.swkm.model2.GraphUtils;
import gr.forth.ics.swkm.model2.Literal;
import gr.forth.ics.swkm.model2.LiteralNode;
import gr.forth.ics.swkm.model2.Model;
import gr.forth.ics.swkm.model2.ObjectNode;
import gr.forth.ics.swkm.model2.RdfNode;
import gr.forth.ics.swkm.model2.RdfType;
import gr.forth.ics.swkm.model2.Resource;
import gr.forth.ics.swkm.model2.Transitively;
import gr.forth.ics.swkm.model2.Triple;
import gr.forth.ics.swkm.model2.Uri;
import gr.forth.ics.swkm.model2.validation.ErrorCode;
import gr.forth.ics.swkm.model2.validation.ValidationException;
import gr.forth.ics.swkm.model2.validation.ValidationHandler;
import gr.forth.ics.swkm.model2.validation.ValidationProblem;
import gr.forth.ics.swkm.model2.views.Inheritable;
import gr.forth.ics.swkm.vocabulary.Rdf;
import gr.forth.ics.swkm.vocabulary.RdfSchema;
import gr.forth.ics.swkm.vocabulary.RdfSuite;
import gr.forth.ics.swkm.vocabulary.XmlSchema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Validator {
    private Validator() {
    }

    public abstract void validate(Model var1, ValidationHandler var2);

    public void validateAndFailOnFirstError(Model model) throws ValidationException {
        this.validate(model, new ValidationHandler(){

            public void handleError(ValidationProblem error) {
                throw new ValidationException(Collections.singleton(error), Collections.<ValidationProblem>emptySet());
            }

            public void handleWarning(ValidationProblem warning) {
            }
        });
    }

    public void validateAndFailOnFirstProblem(Model model) throws ValidationException {
        this.validate(model, new ValidationHandler(){

            public void handleError(ValidationProblem error) {
                throw new ValidationException(Collections.singleton(error), Collections.<ValidationProblem>emptySet());
            }

            public void handleWarning(ValidationProblem warning) {
                throw new ValidationException(Collections.<ValidationProblem>emptySet(), Collections.singleton(warning));
            }
        });
    }

    public static Validator defaultValidator() {
        return new DefaultValidator();
    }

    protected static boolean inDefaultNamespaces(Resource resource) {
        Uri uri = resource.getUri();
        return uri.hasEqualNamespace(Rdf.NAMESPACE) || uri.hasEqualNamespace(RdfSchema.NAMESPACE) || uri.hasEqualNamespace(XmlSchema.NAMESPACE);
    }

    protected static void checkMetaclassesCannotBeTypesOfMetaclasses(Model model, ValidationHandler handler) {
        Resource rdfType = model.mapResource(Rdf.TYPE);
        for (RdfNode metaclass : model.findNodes(RdfType.METACLASS)) {
            for (Triple t : model.triples().s((Resource)metaclass).p(rdfType).fetch()) {
                if (t.object().is(RdfSchema.CLASS)) continue;
                ErrorCode.illegalTriple(t, "A metaclass can only be rdf:type of rdfs:Class, and of nothing else").handledBy(handler);
            }
        }
    }

    protected static void checkPropertiesHaveOneDomainAndRange(Model model, ValidationHandler handler, boolean useInference) {
        HashSet alreadyValidated = Sets.newHashSet();
        for (RdfNode node : model.findNodes(RdfType.PROPERTY)) {
            Resource property = (Resource)node;
            if (Validator.inDefaultNamespaces(property)) continue;
            Validator.checkPropertiesHaveOneDomainAndRange(model, handler, property, alreadyValidated);
        }
    }

    private static void checkPropertiesHaveOneDomainAndRange(Model model, ValidationHandler handler, Resource property, Set<Resource> alreadyValidated) {
        alreadyValidated.add(property);
        for (Uri uri : new Uri[]{RdfSchema.DOMAIN, RdfSchema.RANGE}) {
            Resource mappedUri = model.mapResource(uri);
            Iterable<RdfNode> domainsOrRanges = model.triples().s(property).p(mappedUri).fetch().objects();
            int size = Iterables.size(domainsOrRanges);
            if (size == 0) {
                ArrayList parentDomainsOrRanges = Lists.newArrayList();
                for (Inheritable inheritable : property.asInheritable().ancestors(Transitively.NO)) {
                    Resource parent = (Resource)((Object)inheritable);
                    if (!alreadyValidated.contains(parent)) {
                        Validator.checkPropertiesHaveOneDomainAndRange(model, handler, parent, alreadyValidated);
                    }
                    Iterables.addAll((Collection)parentDomainsOrRanges, model.triples().s(parent).p(uri).fetch().objects());
                }
                for (RdfNode rdfNode : parentDomainsOrRanges) {
                    model.add(null, property, mappedUri, rdfNode);
                }
                domainsOrRanges = model.triples().s(property).p(mappedUri).fetch().objects();
                size = Iterables.size(domainsOrRanges);
            }
            if (size == 1) continue;
            if (size == 0) {
                if (property.is(Rdf.PROPERTY)) continue;
                model.add(null, property, mappedUri, model.mapResource(RdfSchema.RESOURCE));
                if (uri == RdfSchema.DOMAIN) {
                    ErrorCode.noDomain(property).handledBy(handler);
                    continue;
                }
                ErrorCode.noRange(property).handledBy(handler);
                continue;
            }
            ValidationProblem p = uri == RdfSchema.DOMAIN ? ErrorCode.nonUniquePropertyDomain(property, domainsOrRanges) : ErrorCode.nonUniquePropertyRange(property, domainsOrRanges);
            p.handledBy(handler);
        }
    }

    protected void checkNoIllegalDomains(Model model, ValidationHandler handler) {
        for (RdfNode node : model.findNodes(RdfType.PROPERTY, RdfType.METAPROPERTY)) {
            Resource property = (Resource)node;
            Iterable<RdfNode> domains = model.triples().s(property).p(RdfSchema.DOMAIN).fetch().objects();
            for (RdfNode d : domains) {
                Resource domain = (Resource)d;
                if (!domain.type().isXmlType() && !domain.is(RdfSchema.LITERAL)) continue;
                ErrorCode.illegalDomain(property, domain).handledBy(handler);
            }
        }
    }

    protected void checkNoCycleInSubClassOf(Model model, ValidationHandler handler) {
        Graph subClassOfGraph = GraphUtils.toGraph(model, RdfSchema.SUBCLASSOF).graph();
        Path cycle = Cycles.findCycle((InspectableGraph)subClassOfGraph);
        if (cycle != null) {
            ErrorCode.cycleInSubclassOf(cycle).handledBy(handler);
        }
    }

    protected void checkNoCycleInSubPropertyOf(Model model, ValidationHandler handler) {
        Graph subClassOfGraph = GraphUtils.toGraph(model, RdfSchema.SUBPROPERTYOF).graph();
        Path cycle = Cycles.findCycle((InspectableGraph)subClassOfGraph);
        if (cycle != null) {
            ErrorCode.cycleInSubpropertyOf(cycle).handledBy(handler);
        }
    }

    protected void checkSubPropertiesHaveCompatibleDomainsAndRanges(Model model, ValidationHandler handler) {
        for (Triple subPropertyTriple : model.triples().p(RdfSchema.SUBPROPERTYOF).fetch()) {
            Resource subProperty = (Resource)subPropertyTriple.subject();
            Resource superProperty = (Resource)subPropertyTriple.object();
            Resource subDomain = Validator.domainOf(subProperty);
            Resource superDomain = Validator.domainOf(superProperty);
            if (!subDomain.asInheritable().isDescendantOf(superDomain.asInheritable())) {
                ErrorCode.incompatibleDomain(subProperty, subDomain, superProperty, superDomain).handledBy(handler);
            }
            Resource subRange = Validator.rangeOf(subProperty);
            Resource superRange = Validator.rangeOf(superProperty);
            if (subRange.asInheritable().isDescendantOf(superRange.asInheritable())) continue;
            ErrorCode.incompatibleRange(subProperty, subRange, superProperty, superRange).handledBy(handler);
        }
    }

    private static Resource domainOf(Resource property) {
        Model model = property.owner();
        Iterator<RdfNode> domains = model.triples().s(property).p(RdfSchema.DOMAIN).fetch().objects().iterator();
        if (!domains.hasNext()) {
            return null;
        }
        RdfNode domain = domains.next();
        return (Resource)domain;
    }

    private static Resource rangeOf(Resource property) {
        Model model = property.owner();
        Iterator<RdfNode> ranges = model.triples().s(property).p(RdfSchema.RANGE).fetch().objects().iterator();
        if (!ranges.hasNext()) {
            return null;
        }
        RdfNode range = ranges.next();
        return (Resource)range;
    }

    protected static void checkPropertyInstancesHaveCompatibleTypes(Model model, ValidationHandler handler) {
        for (RdfNode n : model.findNodes(RdfType.PROPERTY)) {
            Resource property = (Resource)n;
            if (Validator.inDefaultNamespaces(property)) continue;
            Resource domainResource = Validator.domainOf(property);
            Resource rangeResource = Validator.rangeOf(property);
            if (!domainResource.type().isSchema() || !rangeResource.type().isSchema() && !rangeResource.type().isXmlType()) continue;
            Inheritable domain = domainResource.asInheritable();
            Inheritable range = rangeResource.asInheritable();
            boolean domainIsRdfSuiteClass = domainResource.is(RdfSuite.CLASS);
            boolean rangeIsRdfSuiteClass = rangeResource.is(RdfSuite.CLASS);
            for (Triple pi : model.triples().p(property).fetch()) {
                Inheritable inheritable;
                boolean found;
                Resource rdfType = model.mapResource(Rdf.TYPE);
                ObjectNode subj = pi.subject();
                if (!domainIsRdfSuiteClass || !EnumSet.of(RdfType.METACLASS, RdfType.METAPROPERTY).contains((Object)subj.type())) {
                    found = false;
                    for (RdfNode type : model.triples().s(subj).p(rdfType).fetch().objects()) {
                        inheritable = type.asInheritable();
                        if (!domain.isAncestorOf(inheritable)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        ErrorCode.wronglyTypedSubject(pi, domainResource).handledBy(handler);
                    }
                }
                if (pi.object().isObjectNode()) {
                    ObjectNode obj = (ObjectNode)pi.object();
                    if (rangeIsRdfSuiteClass && EnumSet.of(RdfType.METACLASS, RdfType.METAPROPERTY).contains((Object)obj.type())) continue;
                    found = false;
                    for (RdfNode type : model.triples().s(obj).p(rdfType).fetch().objects()) {
                        inheritable = type.asInheritable();
                        if (!range.isAncestorOf(inheritable)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    ErrorCode.wronglyTypedSubject(pi, domainResource).handledBy(handler);
                    continue;
                }
                Literal literal = ((LiteralNode)pi.object()).getLiteral();
                Uri literalType = literal.hasType() ? literal.getType() : RdfSchema.LITERAL;
                if (rangeResource.is(literalType) || rangeResource.type().isXmlType()) continue;
                ErrorCode.wronglyTypedLiteral(pi, rangeResource).handledBy(handler);
            }
        }
    }

    protected static void checkLiterals(Model model, ValidationHandler handler) {
        for (RdfNode node : model.findNodes(RdfType.LITERAL)) {
            Literal literal = ((LiteralNode)node).getLiteral();
            if (literal.isValid()) continue;
            ErrorCode.illegalLiteral(literal).handledBy(handler);
        }
    }

    protected static class DefaultValidator
    extends Validator {
        protected DefaultValidator() {
        }

        public void validate(Model model, ValidationHandler handler) {
            DefaultValidator.checkMetaclassesCannotBeTypesOfMetaclasses(model, handler);
            DefaultValidator.checkPropertiesHaveOneDomainAndRange(model, handler, false);
            this.checkNoIllegalDomains(model, handler);
            this.checkNoCycleInSubClassOf(model, handler);
            this.checkNoCycleInSubPropertyOf(model, handler);
            this.checkSubPropertiesHaveCompatibleDomainsAndRanges(model, handler);
            DefaultValidator.checkPropertyInstancesHaveCompatibleTypes(model, handler);
            DefaultValidator.checkLiterals(model, handler);
        }
    }
}

