/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.algo;

import gr.forth.ics.graph.InspectableGraph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.path.Path;
import gr.forth.ics.util.Args;

public abstract class AbstractSearch {
    protected final InspectableGraph graph;
    protected Node startNode;
    private int treeCount;
    private Object NODE_TREE_INFO;

    public AbstractSearch(InspectableGraph graph) {
        this(graph, null);
    }

    public AbstractSearch(InspectableGraph graph, Node startNode) {
        Args.notNull((Object)graph);
        this.graph = graph;
        this.startNode = startNode;
    }

    public Node getStartNode() {
        return this.startNode;
    }

    public void setStartNode(Node node) {
        this.startNode = node;
    }

    public InspectableGraph getGraph() {
        return this.graph;
    }

    public final void execute() {
        this.NODE_TREE_INFO = new Object();
        if (this.startNode == null) {
            if (this.graph.nodeCount() == 0) {
                return;
            }
            this.startNode = this.graph.aNode();
        }
        Args.isTrue("Start node not contained in graph", this.graph.containsNode(this.startNode));
        this.treeCount = 0;
        this.executeImpl();
    }

    protected abstract void executeImpl();

    protected void incTreeNumber() {
        ++this.treeCount;
    }

    public int getComponentCount() {
        return this.treeCount;
    }

    protected void markNodeTree(Node node, Object treeIdentifier) {
        node.putWeakly(this.NODE_TREE_INFO, treeIdentifier);
    }

    protected Path storePath(Path path) {
        return path;
    }

    protected boolean visitNewTree(Node node) {
        return false;
    }

    public Object getComponentIdentifier(Node node) {
        return node.get(this.NODE_TREE_INFO);
    }
}

