/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.algo;

import gr.forth.ics.graph.Direction;
import gr.forth.ics.graph.Edge;
import gr.forth.ics.graph.InspectableGraph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.algo.AbstractSearch;
import gr.forth.ics.graph.path.ExpansionFront;
import gr.forth.ics.graph.path.Explorer;
import gr.forth.ics.graph.path.GraphTraversal;
import gr.forth.ics.graph.path.Path;
import gr.forth.ics.graph.path.PathAccumulator;
import gr.forth.ics.graph.path.PathFilter;
import gr.forth.ics.graph.path.Traversal;
import gr.forth.ics.graph.path.Visitor;
import gr.forth.ics.util.Args;

public class Bfs
extends AbstractSearch {
    private final Explorer myExplorer = new Explorer(){

        public void explore(InspectableGraph g, Path currentPath, PathAccumulator accumulator) {
            Node node = currentPath.tailNode();
            for (Edge e : g.edges(node, Direction.OUT)) {
                Path path = currentPath.append(e.asPath(node));
                path = Bfs.this.storePath(path);
                accumulator.addPath(path);
            }
        }
    };
    private Object EDGE_TYPE;
    private Object NODE_INFO;
    private GraphTraversal bfsTraversal;
    private int layerCount;

    public Bfs(InspectableGraph graph) {
        super(graph);
    }

    public Bfs(InspectableGraph graph, Node startNode) {
        super(graph, startNode);
    }

    private void initKeys() {
        this.EDGE_TYPE = new Object();
        this.NODE_INFO = new Object();
    }

    protected void executeImpl() {
        this.initKeys();
        this.layerCount = 0;
        this.bfsTraversal = new GraphTraversal(this.graph, ExpansionFront.newBFS(), PathFilter.euler());
        this.bfsTraversal.setExplorer(this.myExplorer);
        boolean exit = this.bfs(this.startNode);
        if (!exit) {
            for (Node n : this.graph.nodes()) {
                if (!this.isVisited(n) && (exit = this.bfs(n))) break;
            }
        }
        this.bfsTraversal = null;
    }

    protected boolean bfs(Node start) {
        Object tree = new Object();
        this.incTreeNumber();
        this.markNodeTree(start, tree);
        this.markNode(start, 0, null);
        if (this.visitNewTree(start)) {
            return true;
        }
        final boolean[] exit = new boolean[1];
        this.bfsTraversal.traverse(start, new Visitor(){

            public Traversal visit(Path path) {
                if (path.size() == 0) {
                    return Traversal.CONTINUE;
                }
                Edge e = path.tailEdge();
                Node node = path.tailNode();
                if (Bfs.this.isVisited(node)) {
                    Bfs.this.markEdge(e, EdgeType.crossEdge);
                    if (Bfs.this.visitCrossEdge(path)) {
                        exit[0] = true;
                        return Traversal.EXIT;
                    }
                    return Traversal.IGNORE;
                }
                Bfs.this.markEdge(e, EdgeType.treeEdge);
                Node parent = e.opposite(node);
                int level = Bfs.this.getLevel(parent) + 1;
                Bfs.this.markNodeTree(node, Bfs.this.getComponentIdentifier(parent));
                Bfs.this.markNode(node, level, e);
                if (Bfs.this.visitTreeEdge(path)) {
                    exit[0] = true;
                    return Traversal.EXIT;
                }
                return Traversal.CONTINUE;
            }
        });
        return exit[0];
    }

    protected boolean visitTreeEdge(Path path) {
        return false;
    }

    protected boolean visitCrossEdge(Path path) {
        return false;
    }

    public boolean isTreeEdge(Edge e) {
        return this.isType(e, EdgeType.treeEdge);
    }

    public boolean isCrossEdge(Edge e) {
        return this.isType(e, EdgeType.crossEdge);
    }

    private boolean isType(Edge e, EdgeType type) {
        return e.get(this.EDGE_TYPE) == type;
    }

    public boolean isVisited(Node node) {
        return this.getNodeInfo(node) != null;
    }

    public Node getParent(Node node) {
        Edge parent = this.getParentEdge(node);
        if (parent == null) {
            return null;
        }
        return parent.opposite(node);
    }

    public Edge getParentEdge(Node node) {
        NodeInfo nodeInfo = this.getNodeInfo(node);
        if (nodeInfo == null) {
            throw new RuntimeException("Node has not been visited by this bfs (has bfs been executed?)");
        }
        return nodeInfo.parent;
    }

    public int getLayerCount() {
        return this.layerCount;
    }

    public int getLevel(Node node) {
        NodeInfo nodeInfo = this.getNodeInfo(node);
        if (nodeInfo == null) {
            throw new RuntimeException("Node has not been visited by this bfs (has bfs been executed?)");
        }
        return nodeInfo.level;
    }

    private NodeInfo getNodeInfo(Node node) {
        Args.notNull((Object)node);
        return (NodeInfo)node.get(this.NODE_INFO);
    }

    private void markNode(Node node, int level, Edge parent) {
        this.layerCount = Math.max(this.layerCount, level);
        node.putWeakly(this.NODE_INFO, new NodeInfo(level, parent));
    }

    private void markEdge(Edge edge, EdgeType type) {
        edge.putWeakly(this.EDGE_TYPE, (Object)type);
    }

    private static class NodeInfo {
        final int level;
        final Edge parent;

        NodeInfo(int level, Edge parent) {
            this.level = level;
            this.parent = parent;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EdgeType {
        treeEdge,
        crossEdge;

    }
}

