/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.algo;

import gr.forth.ics.graph.InspectableGraph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.algo.Bfs;
import gr.forth.ics.graph.algo.Layerer;
import gr.forth.ics.graph.path.Path;
import gr.forth.ics.util.Args;
import gr.forth.ics.util.DVMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BfsLayerer
extends Bfs
implements Layerer {
    private final Map<Integer, Collection<Node>> layers = DVMap.newHashMapWithHashSets();
    private final Object layerKey = new Object();

    private BfsLayerer(InspectableGraph graph) {
        super(graph);
    }

    private BfsLayerer(InspectableGraph graph, Node startNode) {
        super(graph, startNode);
    }

    static BfsLayerer execute(InspectableGraph g) {
        BfsLayerer bfs = new BfsLayerer(g);
        bfs.execute();
        return bfs;
    }

    static BfsLayerer execute(InspectableGraph g, Node startNode) {
        BfsLayerer bfs = new BfsLayerer(g, startNode);
        bfs.execute();
        return bfs;
    }

    @Override
    protected boolean visitNewTree(Node node) {
        this.addNodeToLayer(node, 0);
        return false;
    }

    @Override
    protected boolean visitTreeEdge(Path path) {
        Node n = path.tailNode();
        this.addNodeToLayer(n, this.getLevel(n));
        return false;
    }

    private void addNodeToLayer(Node node, int layer) {
        this.layers.get(layer).add(node);
        node.putWeakly(this.layerKey, layer);
    }

    @Override
    public Collection<Node> getLayer(int level) {
        Args.gte(level, 0);
        Integer key = level;
        if (this.layers.containsKey(key)) {
            return Collections.unmodifiableCollection(this.layers.get(key));
        }
        return Collections.emptySet();
    }

    @Override
    public Collection<Node> getCluster(Object key) {
        return this.getLayer((Integer)key);
    }

    public Set<Object> getClusters() {
        HashSet<Integer> keys = new HashSet<Integer>();
        for (int i = 0; i < this.getLayerCount(); ++i) {
            keys.add(i);
        }
        return Collections.unmodifiableSet(keys);
    }

    @Override
    public Iterator<Collection<Node>> iterator() {
        return this.layers.values().iterator();
    }

    @Override
    public Object findClusterOf(Node node) {
        return node.get(this.layerKey);
    }
}

