/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.algo;

import gr.forth.ics.graph.Edge;
import gr.forth.ics.graph.Graph;
import gr.forth.ics.graph.InspectableGraph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.algo.Clusterer;
import gr.forth.ics.graph.algo.Clusterers;
import gr.forth.ics.graph.algo.Dfs;
import gr.forth.ics.graph.concrete.PrimaryGraph;
import gr.forth.ics.graph.path.Path;
import gr.forth.ics.graph.util.UndirectedInspectableGraph;
import gr.forth.ics.util.Args;
import java.util.Iterator;
import java.util.LinkedList;

public class Biconnectivity {
    private final Object DISCOVERER = new Object();
    private final Object MARKING_NODE = new Object();
    private final Object IS_CUT_NODE = new Object();
    private final InspectableGraph graph;
    private final Dfs dfs;
    private final Graph cycleGraph;
    private final Clusterer connectedComponents;
    private final int rootsCount;

    private Biconnectivity(InspectableGraph graph) {
        Args.notNull((Object)graph);
        final LinkedList roots = new LinkedList();
        this.graph = graph;
        this.dfs = new Dfs(new UndirectedInspectableGraph(graph)){

            protected boolean visitNewTree(Node v) {
                roots.add(v);
                return false;
            }

            protected boolean visitTreeEdge(Path path) {
                Node to = path.tailNode();
                Edge e = path.tailEdge();
                to.putWeakly(Biconnectivity.this.DISCOVERER, e);
                return false;
            }
        };
        this.cycleGraph = new PrimaryGraph();
        this.dfs.execute();
        this.rootsCount = roots.size();
        for (Node n : roots) {
            this.preorderTraverse(n);
        }
        this.connectedComponents = Clusterers.connectedComponents(this.cycleGraph);
        for (Node n : graph.nodes()) {
            this.computeCutVertex(n);
        }
    }

    public static Biconnectivity execute(InspectableGraph graph) {
        return new Biconnectivity(graph);
    }

    public Object componentOf(Edge e) throws IllegalArgumentException {
        if (!this.graph.containsEdge(e)) {
            throw new IllegalArgumentException("Edge " + e + " does not belong to the graph upon which this algorithm was most recently executed");
        }
        Node nodeMarking = this.nodeMarking(e);
        if (nodeMarking == null) {
            return null;
        }
        return this.connectedComponents.findClusterOf(nodeMarking);
    }

    public boolean isCutNode(Node v) throws IllegalArgumentException {
        if (!this.graph.containsNode(v)) {
            throw new IllegalArgumentException("Node " + v + " does not belong to the graph upon which this algorithm was most recently executed");
        }
        return v.getBoolean(this.IS_CUT_NODE);
    }

    private void computeCutVertex(Node v) {
        Iterator<Edge> edges = this.graph.edges(v).iterator();
        if (edges.hasNext()) {
            Object component = this.componentOf(edges.next());
            while (edges.hasNext()) {
                if (component.equals(this.componentOf(edges.next()))) continue;
                v.putWeakly(this.IS_CUT_NODE, true);
                return;
            }
        }
        v.putWeakly(this.IS_CUT_NODE, false);
    }

    private void preorderTraverse(Node v) {
        LinkedList<Edge> discoveryEdges = new LinkedList<Edge>();
        block0: for (Edge e : this.graph.edges(v)) {
            if (this.dfs.isTreeEdge(e) && this.dfs.getParent(e.opposite(v)) == v) {
                discoveryEdges.addFirst(e);
                continue;
            }
            if (!this.dfs.isBackEdge(e) || this.isMarked(e)) continue;
            Node vE = this.cycleGraph.newNode(e);
            this.mark(e, vE);
            Node u = e.opposite(v);
            while (u != v) {
                Edge discoversU = this.discoverer(u);
                if (this.isMarked(discoversU)) {
                    this.cycleGraph.newEdge(this.nodeMarking(discoversU), vE, null);
                    continue block0;
                }
                Node vDU = this.cycleGraph.newNode(discoversU);
                this.mark(discoversU, vDU);
                this.cycleGraph.newEdge(vE, vDU, null);
                u = discoversU.opposite(u);
            }
        }
        for (Edge e : discoveryEdges) {
            this.preorderTraverse(e.opposite(v));
            if (this.isMarked(e)) continue;
            this.mark(e, this.cycleGraph.newNode(e));
        }
    }

    private void mark(Edge e, Node vE) {
        e.putWeakly(this.MARKING_NODE, vE);
    }

    private boolean isMarked(Edge e) {
        return e.has(this.MARKING_NODE);
    }

    private Node nodeMarking(Edge e) {
        return e.getNode(this.MARKING_NODE);
    }

    private Edge discoverer(Node v) {
        return v.getEdge(this.DISCOVERER);
    }

    public InspectableGraph getGraph() {
        return this.graph;
    }

    public int componentsCount() {
        return this.rootsCount;
    }
}

