/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.algo;

import gr.forth.ics.graph.Direction;
import gr.forth.ics.graph.Edge;
import gr.forth.ics.graph.InspectableGraph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.event.GraphEvent;
import gr.forth.ics.graph.event.WeakListener;
import gr.forth.ics.util.Args;
import gr.forth.ics.util.DVMap;
import gr.forth.ics.util.Factory;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BucketSort {
    private final MyListener listener;
    protected final DVMap<Integer, Collection<Node>> nodes = new DVMap(new TreeMap(), new Factory<Collection<Node>>(){

        @Override
        public Collection<Node> create(Object o) {
            return new Collection<Node>(){
                final Map<Node, Boolean> map = new ConcurrentHashMap<Node, Boolean>();
                final Set<Node> set = this.map.keySet();

                @Override
                public int size() {
                    return this.map.size();
                }

                @Override
                public boolean isEmpty() {
                    return this.map.isEmpty();
                }

                @Override
                public boolean contains(Object o) {
                    return this.map.containsKey(o);
                }

                @Override
                public Iterator<Node> iterator() {
                    return this.map.keySet().iterator();
                }

                @Override
                public Object[] toArray() {
                    return this.map.keySet().toArray();
                }

                @Override
                public <T> T[] toArray(T[] a) {
                    return this.map.keySet().toArray(a);
                }

                @Override
                public boolean add(Node e) {
                    return this.map.put(e, Boolean.TRUE) != null;
                }

                @Override
                public boolean remove(Object o) {
                    return this.set.remove(o);
                }

                @Override
                public boolean containsAll(Collection<?> c) {
                    return this.set.containsAll(c);
                }

                @Override
                public boolean addAll(Collection<? extends Node> c) {
                    boolean changed = false;
                    for (Node node : c) {
                        changed |= this.map.put(node, null) != null;
                    }
                    return changed;
                }

                @Override
                public boolean removeAll(Collection<?> c) {
                    return this.set.removeAll(c);
                }

                @Override
                public boolean retainAll(Collection<?> c) {
                    return this.set.retainAll(c);
                }

                @Override
                public void clear() {
                    this.map.clear();
                }

                public String toString() {
                    return this.set.toString();
                }
            };
        }
    });
    protected final Direction direction;

    public BucketSort(InspectableGraph g) {
        this(g, Direction.EITHER);
    }

    public BucketSort(InspectableGraph g, Direction degreeDirection) {
        Args.notNull(new Object[]{g, degreeDirection});
        this.direction = degreeDirection;
        for (Node n : g.nodes()) {
            this.nodes.get(g.degree(n, degreeDirection)).add(n);
        }
        this.listener = new MyListener(this);
        g.addGraphListener(this.listener);
    }

    public Collection<Node> getNodes(int degree) {
        Integer key = new Integer(degree);
        if (this.nodes.containsKey(key)) {
            return Collections.unmodifiableCollection(this.nodes.get(key));
        }
        return Collections.emptySet();
    }

    public boolean hasNodes(int degree) {
        return this.nodes.containsKey(degree);
    }

    public Set<Integer> keySet() {
        return Collections.unmodifiableSet(this.nodes.keySet());
    }

    public int getMaxDegree() {
        if (this.nodes.isEmpty()) {
            throw new NoSuchElementException();
        }
        return (Integer)((SortedMap)this.nodes.getDelegate()).lastKey();
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public int getMinDegree() {
        if (this.nodes.isEmpty()) {
            throw new NoSuchElementException("Graph is empty");
        }
        return (Integer)((SortedMap)this.nodes.getDelegate()).firstKey();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyListener
    extends WeakListener<BucketSort> {
        GraphEvent pendingEdgeRemoval;

        MyListener(BucketSort sort) {
            super(sort);
        }

        private void removeNode(InspectableGraph g, Node n) {
            BucketSort sort = (BucketSort)this.getEntity();
            this.removeNode(g, n, g.containsNode(n) ? g.degree(n, sort.direction) : 0);
        }

        private void removeNode(InspectableGraph g, Node n, Integer degree) {
            BucketSort sort = (BucketSort)this.getEntity();
            Collection<Node> col = sort.nodes.get(degree);
            col.remove(n);
            if (col.isEmpty()) {
                sort.nodes.remove(degree);
            }
        }

        @Override
        public void nodeRemoved(GraphEvent e) {
            BucketSort sort = (BucketSort)this.getEntity();
            if (sort == null) {
                e.getSource().removeGraphListener(this);
                return;
            }
            this.removeNode(e.getSource(), e.getNode());
        }

        @Override
        public void nodeAdded(GraphEvent e) {
            BucketSort sort = (BucketSort)this.getEntity();
            if (sort == null) {
                e.getSource().removeGraphListener(this);
                return;
            }
            sort.nodes.get(0).add(e.getNode());
        }

        @Override
        public void edgeRemoved(GraphEvent e) {
            int d2;
            BucketSort sort = (BucketSort)this.getEntity();
            if (sort == null) {
                e.getSource().removeGraphListener(this);
                return;
            }
            InspectableGraph g = e.getSource();
            Edge ed = e.getEdge();
            Node n1 = ed.n1();
            Node n2 = ed.n2();
            int d1 = sort.direction.isOut() ? 1 : 0;
            int n = d2 = sort.direction.isIn() ? 1 : 0;
            if (n1 == n2) {
                switch (sort.direction) {
                    case EITHER: {
                        d2 = 2;
                        d1 = 2;
                        break;
                    }
                    case OUT: {
                        d2 = d1;
                        break;
                    }
                    case IN: {
                        d1 = d2;
                    }
                }
            }
            this.removeNode(g, n1, g.degree(n1, sort.direction) + d1);
            this.removeNode(g, n2, g.degree(n2, sort.direction) + d2);
            sort.nodes.get(g.degree(n1, sort.direction)).add(n1);
            sort.nodes.get(g.degree(n2, sort.direction)).add(n2);
        }

        @Override
        public void edgeAdded(GraphEvent e) {
            int d2;
            BucketSort sort = (BucketSort)this.getEntity();
            if (sort == null) {
                e.getSource().removeGraphListener(this);
                return;
            }
            InspectableGraph g = e.getSource();
            Edge ed = e.getEdge();
            Node n1 = ed.n1();
            Node n2 = ed.n2();
            int d1 = sort.direction.isOut() ? 1 : 0;
            int n = d2 = sort.direction.isIn() ? 1 : 0;
            if (n1 == n2) {
                switch (sort.direction) {
                    case EITHER: {
                        d1 = 2;
                        d2 = 2;
                        break;
                    }
                    case OUT: {
                        d2 = d1;
                        break;
                    }
                    case IN: {
                        d1 = d2;
                    }
                }
            }
            this.removeNode(g, n1, g.degree(n1, sort.direction) - d1);
            this.removeNode(g, n2, g.degree(n2, sort.direction) - d2);
            sort.nodes.get(g.degree(n1, sort.direction)).add(n1);
            sort.nodes.get(g.degree(n2, sort.direction)).add(n2);
        }
    }
}

