/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.algo;

import gr.forth.ics.graph.Direction;
import gr.forth.ics.graph.Graph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.algo.Generators;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

class KleinbergSmallWorldGenerator {
    private final int latticeSize;
    private final int longRangeDistanceDistributionsSize;
    private final double clusteringExponent;
    private final Random random;

    KleinbergSmallWorldGenerator(Random random, int latticeSize, double clusteringExponent) {
        this.random = random;
        this.latticeSize = latticeSize;
        this.longRangeDistanceDistributionsSize = latticeSize * 1000;
        this.clusteringExponent = clusteringExponent;
    }

    void generate(Graph graph) {
        Generators.createFoldedGrid(graph, this.latticeSize, this.latticeSize);
        List nodes = graph.nodes().drainToList();
        int[] longRangeDistanceDistributions = this.computeLongDistanceEdgeDistributionSample();
        int numNodes = (int)Math.pow(this.latticeSize, 2.0);
        for (int i = 0; i < numNodes; ++i) {
            int randomNodeIndex;
            Node target;
            Node source;
            int sampleNodeIndex = this.random.nextInt(this.longRangeDistanceDistributionsSize);
            int randomDistance = longRangeDistanceDistributions[sampleNodeIndex];
            do {
                randomNodeIndex = this.simulatePath(i, randomDistance);
            } while (graph.areAdjacent(source = (Node)nodes.get(i), target = (Node)nodes.get(randomNodeIndex), Direction.OUT));
            graph.newEdge(source, target);
        }
    }

    private int pickValue(boolean[] choices) {
        int i;
        block5: {
            int totalNumChoicesLeft = 0;
            for (int x = 0; x < choices.length; ++x) {
                if (!choices[x]) continue;
                ++totalNumChoicesLeft;
            }
            double randValue = this.random.nextDouble();
            for (i = 1; i <= totalNumChoicesLeft; ++i) {
                if (!(randValue < (double)i / (double)totalNumChoicesLeft)) {
                    continue;
                }
                break block5;
            }
            throw new AssertionError((Object)"Cannot reach here");
        }
        int choice = i;
        int currentChoice = 1;
        for (int j = 0; j < choices.length; ++j) {
            if (!choices[j]) continue;
            if (currentChoice == choice) {
                return j + 1;
            }
            ++currentChoice;
        }
        return currentChoice;
    }

    private int simulatePath(int index, int distance) {
        boolean[] currentChoices = new boolean[4];
        Arrays.fill(currentChoices, true);
        int currentChoice = 0;
        int newIndex = 0;
        int xCoordinate = index / this.latticeSize;
        int yCoordinate = index % this.latticeSize;
        for (int numSteps = 0; numSteps < distance; ++numSteps) {
            currentChoice = this.pickValue(currentChoices);
            switch (currentChoice) {
                case 1: {
                    currentChoices[1] = false;
                    newIndex = this.upIndex(xCoordinate, yCoordinate);
                    break;
                }
                case 2: {
                    currentChoices[0] = false;
                    newIndex = this.downIndex(xCoordinate, yCoordinate);
                    break;
                }
                case 3: {
                    currentChoices[3] = false;
                    newIndex = this.leftIndex(xCoordinate, yCoordinate);
                    break;
                }
                case 4: {
                    currentChoices[2] = false;
                    newIndex = this.rightIndex(xCoordinate, yCoordinate);
                }
            }
            xCoordinate = newIndex / this.latticeSize;
            yCoordinate = newIndex % this.latticeSize;
        }
        return newIndex;
    }

    public double getClusteringExponent() {
        return this.clusteringExponent;
    }

    private int[] computeLongDistanceEdgeDistributionSample() {
        int i;
        int numLongRangeLevels = this.latticeSize - 2;
        if (this.latticeSize % 2 == 0) {
            numLongRangeLevels = this.latticeSize - 1;
        }
        double[] probDists = new double[numLongRangeLevels];
        double normalizingFactor = 0.0;
        int currentDistance = 2;
        for (i = 0; i < numLongRangeLevels; ++i) {
            probDists[i] = Math.pow(currentDistance, -1.0 * this.clusteringExponent);
            normalizingFactor += probDists[i];
            ++currentDistance;
        }
        i = 0;
        while (i < numLongRangeLevels) {
            int n = i++;
            probDists[n] = probDists[n] / normalizingFactor;
        }
        int[] longRangeDistanceDistributions = new int[this.longRangeDistanceDistributionsSize];
        block2: for (int i2 = 0; i2 < this.longRangeDistanceDistributionsSize; ++i2) {
            currentDistance = 2;
            double currentCumProb = 0.0;
            double randomVal = Math.random();
            for (int j = 0; j < numLongRangeLevels; ++j) {
                if (randomVal < (currentCumProb += probDists[j])) {
                    longRangeDistanceDistributions[i2] = currentDistance;
                    continue block2;
                }
                ++currentDistance;
            }
        }
        return longRangeDistanceDistributions;
    }

    private int upIndex(int currentLatticeRow, int currentLatticeColumn) {
        if (currentLatticeRow == 0) {
            return this.latticeSize * (this.latticeSize - 1) + currentLatticeColumn;
        }
        return (currentLatticeRow - 1) * this.latticeSize + currentLatticeColumn;
    }

    private int downIndex(int currentLatticeRow, int currentLatticeColumn) {
        if (currentLatticeRow == this.latticeSize - 1) {
            return currentLatticeColumn;
        }
        return (currentLatticeRow + 1) * this.latticeSize + currentLatticeColumn;
    }

    private int leftIndex(int currentLatticeRow, int currentLatticeColumn) {
        if (currentLatticeColumn == 0) {
            return currentLatticeRow * this.latticeSize + this.latticeSize - 1;
        }
        return currentLatticeRow * this.latticeSize + currentLatticeColumn - 1;
    }

    private int rightIndex(int currentLatticeRow, int currentLatticeColumn) {
        if (currentLatticeColumn == this.latticeSize - 1) {
            return currentLatticeRow * this.latticeSize;
        }
        return currentLatticeRow * this.latticeSize + currentLatticeColumn + 1;
    }
}

