/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.algo;

import gr.forth.ics.graph.InspectableGraph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.path.ExpansionFront;
import gr.forth.ics.graph.path.GraphTraversal;
import gr.forth.ics.graph.path.Path;
import gr.forth.ics.graph.path.PathFilter;
import gr.forth.ics.graph.path.Traversal;
import gr.forth.ics.graph.path.Visitor;

public class TreeNodeLevelFinder {
    private final InspectableGraph graph;
    private final Object LAYERS_BELOW;
    private final Object LAYERS_ABOVE;

    private TreeNodeLevelFinder(InspectableGraph graph, Object LAYERS_BELOW, Object LAYERS_ABOVE) {
        this.graph = graph;
        this.LAYERS_BELOW = LAYERS_BELOW;
        this.LAYERS_ABOVE = LAYERS_ABOVE;
    }

    public static TreeNodeLevelFinder analyze(InspectableGraph graph, Node root) {
        final Object LAYERS_BELOW = new Object();
        final Object LAYERS_ABOVE = new Object();
        GraphTraversal traversal = new GraphTraversal(graph, ExpansionFront.newDFS(), PathFilter.euler());
        traversal.traverse(root, new Visitor(){

            public Traversal visit(Path path) {
                Node parent;
                int underneathLevels;
                if (path.tailNode().has(LAYERS_ABOVE)) {
                    int existingLayersAbove = path.tailNode().getInt(LAYERS_ABOVE);
                    path.tailNode().putWeakly(LAYERS_ABOVE, Math.min(existingLayersAbove, path.size()));
                } else {
                    path.tailNode().putWeakly(LAYERS_ABOVE, path.size());
                }
                if (!path.tailNode().has(LAYERS_BELOW)) {
                    path.tailNode().putWeakly(LAYERS_BELOW, 0);
                }
                for (int i = 1; i < path.nodeCount() && (underneathLevels = (parent = path.getNode(path.nodeCount() - i - 1)).getInt(LAYERS_BELOW)) < i; ++i) {
                    parent.putWeakly(LAYERS_BELOW, i);
                }
                return null;
            }
        });
        return new TreeNodeLevelFinder(graph, LAYERS_BELOW, LAYERS_ABOVE);
    }

    public InspectableGraph getGraph() {
        return this.graph;
    }

    public int getLayersBelow(Node node) {
        if (!node.has(this.LAYERS_BELOW)) {
            throw new IllegalArgumentException("Node " + node + " was not in the tree");
        }
        return node.getInt(this.LAYERS_BELOW);
    }

    public int getLayersAbove(Node node) {
        if (!node.has(this.LAYERS_ABOVE)) {
            throw new IllegalArgumentException("Node " + node + " was not in the tree");
        }
        return node.getInt(this.LAYERS_ABOVE);
    }
}

