/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.algo.transitivity;

import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.algo.transitivity.Closure;
import gr.forth.ics.graph.algo.transitivity.SuccessorSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

class ClosureImpl
implements Closure {
    private final Object successorSetKey = new Object();
    private static final SuccessorSet EMPTY_SET = new SuccessorSet(){

        @Override
        public boolean contains(Node node) {
            return false;
        }

        @Override
        public Set<Node> toSet() {
            return Collections.emptySet();
        }

        @Override
        public Iterator<Node> iterator() {
            return this.toSet().iterator();
        }
    };

    ClosureImpl() {
    }

    void setSuccessors(Node node, SuccessorSet successorSet) {
        node.putWeakly(this.successorSetKey, successorSet);
    }

    void removeSuccessors(Node node) {
        node.remove(this.successorSetKey);
    }

    public SuccessorSet successorsOf(Node node) {
        SuccessorSet set = (SuccessorSet)node.get(this.successorSetKey);
        if (set == null) {
            return EMPTY_SET;
        }
        return set;
    }

    public boolean pathExists(Node n1, Node n2) {
        return this.successorsOf(n1).contains(n2);
    }
}

