/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.algo.transitivity;

import gr.forth.ics.graph.InspectableGraph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.algo.transitivity.PathFinder;
import gr.forth.ics.graph.path.ExpansionFront;
import gr.forth.ics.graph.path.GraphTraversal;
import gr.forth.ics.graph.path.Path;
import gr.forth.ics.graph.path.PathFilter;
import gr.forth.ics.graph.path.Traversal;
import gr.forth.ics.graph.path.Visitor;

public class PathFinders {
    private PathFinders() {
    }

    public static PathFinder navigational(InspectableGraph g) {
        if (g == null) {
            throw new NullPointerException();
        }
        return new NavigationalPathFinder(g);
    }

    private static class NavigationalPathFinder
    implements PathFinder {
        private final InspectableGraph g;

        NavigationalPathFinder(InspectableGraph g) {
            this.g = g;
        }

        public boolean pathExists(Node n1, final Node n2) {
            GraphTraversal traversal = new GraphTraversal(this.g, ExpansionFront.newDFS(), PathFilter.hamilton());
            final boolean[] found = new boolean[]{false};
            traversal.traverse(n1, new Visitor(){

                public Traversal visit(Path path) {
                    if (path.size() == 0 || path.tailNode() != n2) {
                        return Traversal.CONTINUE;
                    }
                    found[0] = true;
                    return Traversal.EXIT;
                }
            });
            return found[0];
        }
    }
}

