/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.algo.transitivity;

import gr.forth.ics.graph.InspectableGraph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.algo.transitivity.MutableSuccessorSet;
import gr.forth.ics.graph.algo.transitivity.SuccessorSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public abstract class SuccessorSetFactory {
    public abstract MutableSuccessorSet create();

    public static SuccessorSetFactory hashSetBased() {
        return HashSetBasedSuccessorSetFactory.instance;
    }

    public static SuccessorSetFactory intervalBased(InspectableGraph graph) {
        return new IntervalBasedSuccessorSetFactory(graph);
    }

    static class IntervalBasedSuccessorSetFactory
    extends SuccessorSetFactory {
        private final InspectableGraph graph;
        private final Node[] nodes;
        private final Object indexKey = new Object();

        IntervalBasedSuccessorSetFactory(InspectableGraph graph) {
            this.graph = graph;
            this.nodes = new Node[graph.nodeCount()];
            int pos = 0;
            for (Node n : graph.nodes()) {
                n.putWeakly(this.indexKey, pos);
                this.nodes[pos++] = n;
            }
        }

        public MutableSuccessorSet create() {
            return new IntervalSet();
        }

        static class Interval {
            int start;
            int end;
            Interval next;

            Interval(int start, int end, Interval next) {
                this.start = start;
                this.end = end;
                this.next = next;
            }

            static Interval newSentinel() {
                return new Interval(-1, Integer.MIN_VALUE, null){

                    Interval add(int s, int e) {
                        if (this.next != null) {
                            if (e < this.next.start - 1) {
                                this.next = new Interval(s, e, this.next);
                            } else if (s < this.next.start) {
                                this.next.start = s;
                            }
                            return this.next.add(s, e);
                        }
                        this.next = new Interval(s, e, null);
                        return this.next;
                    }

                    public String toString() {
                        if (this.next == null) {
                            return "[]";
                        }
                        return this.next.toString();
                    }
                };
            }

            boolean contains(int index) {
                Interval current = this;
                while (true) {
                    if (index < current.start) {
                        return false;
                    }
                    if (index <= current.end) {
                        return true;
                    }
                    if (current.next == null) break;
                    current = current.next;
                }
                return false;
            }

            Interval add(int s, int e) {
                Interval current = this;
                while (e > current.end) {
                    Interval next;
                    if (s <= current.end + 1) {
                        current.end = e;
                        next = current.next;
                        while (next != null && next.start <= e + 1) {
                            current.end = Math.max(e, next.end);
                            next = current.next = next.next;
                        }
                        return current;
                    }
                    next = current.next;
                    if (next != null) {
                        if (e < next.start - 1) {
                            current.next = new Interval(s, e, next);
                            return current.next;
                        }
                        if (s >= next.start) {
                            current = next;
                            continue;
                        }
                        next.start = s;
                        current = next;
                        continue;
                    }
                    current.next = new Interval(s, e, null);
                }
                return current;
            }

            void merge(Interval interval) {
                Interval next = interval.next;
                Interval base = this;
                while (next != null) {
                    base = base.add(next.start, next.end);
                    next = next.next;
                }
            }

            int size() {
                int size = 0;
                Interval current = this.next;
                while (current != null) {
                    size += current.end - current.start + 1;
                    current = current.next;
                }
                return size;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("[").append(this.start).append("-").append(this.end);
                Interval next = this.next;
                while (next != null) {
                    sb.append(",").append(next.start).append("-").append(next.end);
                    next = next.next;
                }
                sb.append("]");
                return sb.toString();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class IntervalSet
        implements MutableSuccessorSet {
            private final Interval head = Interval.newSentinel();

            private IntervalSet() {
            }

            @Override
            public void add(Node node) {
                int index = node.getInt(IntervalBasedSuccessorSetFactory.this.indexKey);
                this.head.add(index, index);
            }

            @Override
            public void addAll(SuccessorSet successorSet) {
                Interval intervalSet = ((IntervalSet)successorSet).head;
                this.head.merge(intervalSet);
            }

            @Override
            public boolean contains(Node node) {
                return this.head.contains(node.getInt(IntervalBasedSuccessorSetFactory.this.indexKey));
            }

            @Override
            public Set<Node> toSet() {
                HashSet<Node> nodes = new HashSet<Node>(this.head.size());
                for (Node n : this) {
                    nodes.add(n);
                }
                return nodes;
            }

            @Override
            public Iterator<Node> iterator() {
                if (this.head.next == null) {
                    return Collections.emptyList().iterator();
                }
                return new Iterator<Node>(){
                    Interval current;
                    int index;
                    boolean hasNext;
                    {
                        this.current = ((IntervalSet)IntervalSet.this).head.next;
                        this.index = this.current.start;
                        this.hasNext = true;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.hasNext;
                    }

                    @Override
                    public Node next() {
                        if (!this.hasNext) {
                            throw new NoSuchElementException();
                        }
                        Node next = IntervalBasedSuccessorSetFactory.this.nodes[this.index];
                        ++this.index;
                        if (this.index > this.current.end) {
                            this.current = this.current.next;
                            if (this.current == null) {
                                this.hasNext = false;
                            } else {
                                this.index = this.current.start;
                            }
                        }
                        return next;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }
                };
            }

            public String toString() {
                return this.head.toString();
            }
        }
    }

    private static class HashSetBasedSuccessorSetFactory
    extends SuccessorSetFactory {
        static final SuccessorSetFactory instance = new HashSetBasedSuccessorSetFactory();

        private HashSetBasedSuccessorSetFactory() {
        }

        public MutableSuccessorSet create() {
            return new HashSetBasedSuccessorSet();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class HashSetBasedSuccessorSet
        implements MutableSuccessorSet {
            private final Set<Node> successors = new HashSet<Node>();

            private HashSetBasedSuccessorSet() {
            }

            @Override
            public boolean contains(Node node) {
                return this.successors.contains(node);
            }

            @Override
            public Set<Node> toSet() {
                return Collections.unmodifiableSet(this.successors);
            }

            @Override
            public Iterator<Node> iterator() {
                return this.successors.iterator();
            }

            @Override
            public void add(Node node) {
                this.successors.add(node);
            }

            @Override
            public void addAll(SuccessorSet successorSet) {
                for (Node n : successorSet) {
                    this.successors.add(n);
                }
            }

            public String toString() {
                return this.successors.toString();
            }

            public boolean equals(Object that) {
                if (!(that instanceof HashSetBasedSuccessorSet)) {
                    return false;
                }
                return ((Object)this.successors).equals(((HashSetBasedSuccessorSet)that).successors);
            }

            public int hashCode() {
                return ((Object)this.successors).hashCode();
            }
        }
    }
}

