/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.concrete;

import gr.forth.ics.graph.Edge;
import gr.forth.ics.graph.Graph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.concrete.AbstractInspectableGraph;
import gr.forth.ics.util.Args;
import gr.forth.ics.util.ExtendedIterable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGraph
extends AbstractInspectableGraph
implements Graph {
    @Override
    public int removeEdges(Iterable<Edge> edges) {
        if (edges == null) {
            return 0;
        }
        int removed = 0;
        for (Edge e : edges) {
            if (!this.removeEdge(e)) continue;
            ++removed;
        }
        return removed;
    }

    @Override
    public Node[] newNodes(int count) {
        if (count < 0) {
            throw new IllegalArgumentException();
        }
        Node[] ids = new Node[count];
        for (int i = 0; i < count; ++i) {
            ids[i] = this.newNode(null);
        }
        return ids;
    }

    @Override
    public Node newNode() {
        return this.newNode(null);
    }

    @Override
    public Edge newEdge(Node n1, Node n2) {
        return this.newEdge(n1, n2, null);
    }

    @Override
    public Node[] newNodes(Object ... values) {
        Node[] ids = new Node[values.length];
        for (int i = 0; i < values.length; ++i) {
            ids[i] = this.newNode(values[i]);
        }
        return ids;
    }

    @Override
    public int removeNodes(Iterable<Node> nodes) {
        if (nodes == null) {
            return 0;
        }
        int removed = 0;
        for (Node node : nodes) {
            if (!this.removeNode(node)) continue;
            ++removed;
        }
        return removed;
    }

    @Override
    public int removeAllEdges() {
        int countEdges = this.edgeCount();
        for (Edge e : this.edges()) {
            this.removeEdge(e);
        }
        return countEdges;
    }

    @Override
    public int removeAllNodes() {
        int countNodes = this.nodeCount();
        for (Node n : this.nodes()) {
            this.removeNode(n);
        }
        return countNodes;
    }

    @Override
    public boolean isPrimary() {
        return false;
    }

    @Override
    public void importGraph(Graph g) {
        this.importGraph(g, g.nodes());
    }

    @Override
    public Collection<Edge> importGraph(Graph g, Iterable<Node> nodes) {
        Args.notNull((Object)g);
        if (nodes == null) {
            return Collections.emptyList();
        }
        LinkedList<Edge> innerEdges = new LinkedList<Edge>();
        LinkedList<Edge> interEdges = new LinkedList<Edge>();
        List<Node> importedNodes = ExtendedIterable.wrap(nodes).drainTo(new LinkedList());
        for (Node n : importedNodes) {
            if (!g.containsNode(n)) {
                throw new IllegalArgumentException("Node not in imported graph");
            }
            for (Edge e : g.edges(n)) {
                if (importedNodes.contains(e.n1()) && importedNodes.contains(e.n2())) {
                    innerEdges.add(e);
                    continue;
                }
                interEdges.add(e);
            }
            g.removeNode(n);
        }
        for (Node n : importedNodes) {
            this.reinsertNode(n);
        }
        for (Edge inner : innerEdges) {
            this.reinsertEdge(inner);
        }
        return interEdges;
    }

    @Override
    public Edge[] split(Edge e) {
        return this.split(e, null);
    }

    @Override
    public Edge[] split(Edge e, Object innerNodeValue) {
        Args.notNull((Object)e);
        if (!this.containsEdge(e)) {
            throw new IllegalArgumentException("Edge: " + e + " not contained in this graph");
        }
        if (e.isSelfLoop()) {
            throw new IllegalArgumentException("Cannot split a self-loop");
        }
        Node inner = this.newNode(innerNodeValue);
        Edge[] edges = new Edge[]{this.newEdge(e.n1(), inner), this.newEdge(inner, e.n2())};
        this.removeEdge(e);
        for (Edge edge : edges) {
            e.copyInto(edge);
        }
        return edges;
    }

    @Override
    public Edge merge(Edge e1, Edge e2) {
        Args.notNull(e1, e2);
        if (!this.containsEdge(e1) || !this.containsEdge(e2)) {
            throw new IllegalArgumentException("One edge of: " + e1 + ", " + e2 + " not contained in this graph");
        }
        if (e1.n2() != e2.n1()) {
            throw new IllegalArgumentException("Edges must be consecutive");
        }
        Node inner = e1.n2();
        if (this.degree(inner) != 2) {
            throw new IllegalArgumentException("Inner node: " + inner + " cannot be removed, there are other edges binding it");
        }
        Edge edge = this.newEdge(e1.n1(), e2.n2());
        e1.copyInto(edge);
        e2.copyInto(edge);
        this.removeNode(inner);
        return edge;
    }
}

