/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.concrete;

import gr.forth.ics.graph.Direction;
import gr.forth.ics.graph.Edge;
import gr.forth.ics.graph.Graph;
import gr.forth.ics.graph.Hint;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.concrete.AbstractGraph;
import gr.forth.ics.graph.concrete.EdgeImpl;
import gr.forth.ics.graph.concrete.NodeImpl;
import gr.forth.ics.graph.event.GraphEvent;
import gr.forth.ics.util.AbstractCompoundListIterator;
import gr.forth.ics.util.Accessor;
import gr.forth.ics.util.Args;
import gr.forth.ics.util.CompoundListIterator;
import gr.forth.ics.util.ExtendedListIterable;
import gr.forth.ics.util.FastLinkedList;
import gr.forth.ics.util.Filter;
import gr.forth.ics.util.FilteringListIterator;
import java.lang.ref.SoftReference;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractListGraph
extends AbstractGraph {
    protected final FastLinkedList<NodeImpl> nodes = new FastLinkedList();
    private SoftReference<List<Node>> nodesCache;
    private SoftReference<List<Edge>> edgesCache;

    protected abstract void setNodeRef(NodeImpl var1, Accessor<NodeImpl> var2);

    protected abstract void setEdgeOutRef(EdgeImpl var1, Accessor<EdgeImpl> var2);

    protected abstract void setEdgeInRef(EdgeImpl var1, Accessor<EdgeImpl> var2);

    protected abstract Accessor<NodeImpl> getNodeRef(NodeImpl var1);

    protected abstract Accessor<EdgeImpl> getEdgeOutRef(EdgeImpl var1);

    protected abstract Accessor<EdgeImpl> getEdgeInRef(EdgeImpl var1);

    protected abstract void removeNodeRef(NodeImpl var1);

    protected abstract void removeEdgeRefs(EdgeImpl var1);

    protected abstract FastLinkedList<EdgeImpl> getOutEdges(NodeImpl var1);

    protected abstract FastLinkedList<EdgeImpl> getInEdges(NodeImpl var1);

    protected abstract void initNode(NodeImpl var1);

    @Override
    public Node newNode(Object value) {
        final NodeImpl node = new NodeImpl(value);
        this.graphEventSupport.fire(new GraphEvent(this, GraphEvent.Type.NODE_ADDED, node), new Runnable(){

            public void run() {
                AbstractListGraph.this.initNode(node);
                AbstractListGraph.this.setNodeRef(node, AbstractListGraph.this.nodes.addLast(node));
                AbstractListGraph.this.nodesCache = null;
            }
        });
        return node;
    }

    @Override
    public Edge newEdge(Node n1, Node n2, Object value) {
        Args.notNull(n1, n2);
        final NodeImpl node1 = this.checkContainedAndCast(n1);
        final NodeImpl node2 = this.checkContainedAndCast(n2);
        final EdgeImpl edge = new EdgeImpl(node1, node2, value);
        this.graphEventSupport.fire(new GraphEvent(this, GraphEvent.Type.EDGE_ADDED, edge), new Runnable(){

            public void run() {
                ++AbstractListGraph.this.edgeCount;
                Accessor<EdgeImpl> outRef = AbstractListGraph.this.getOutEdges(node1).addLast(edge);
                Accessor<EdgeImpl> inRef = AbstractListGraph.this.getInEdges(node2).addLast(edge);
                AbstractListGraph.this.setEdgeOutRef(edge, outRef);
                AbstractListGraph.this.setEdgeInRef(edge, inRef);
                AbstractListGraph.this.edgesCache = null;
            }
        });
        return edge;
    }

    @Override
    public int nodeCount() {
        return this.nodes.size();
    }

    @Override
    public int edgeCount() {
        return this.edgeCount;
    }

    private NodeImpl checkContainedAndCast(Node node) {
        if (!this.containsNode(node)) {
            throw new IllegalArgumentException("Node " + node + " not contained in graph");
        }
        return (NodeImpl)node;
    }

    private EdgeImpl checkContainedAndCast(Edge edge) {
        if (!this.containsEdge(edge)) {
            throw new IllegalArgumentException("Edge " + edge + " not contained in graph");
        }
        return (EdgeImpl)edge;
    }

    protected final ExtendedListIterable<Node> iterableNodes(final FastLinkedList<NodeImpl> seq, int expectedSize) {
        return new ExtendedListIterable<Node>(expectedSize){

            @Override
            protected ListIterator<Node> listIteratorImpl() {
                return new ListIterator<Node>(){
                    final ListIterator<Node> iter;
                    Node last;
                    int index;
                    {
                        this.iter = AbstractListGraph.castNodes(seq).listIterator(0);
                        this.index = 0;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public Node next() {
                        this.last = this.iter.next();
                        ++this.index;
                        return this.last;
                    }

                    @Override
                    public void remove() {
                        if (this.last == null) {
                            throw new IllegalStateException();
                        }
                        AbstractListGraph.this.removeNode(this.last);
                        this.last = null;
                    }

                    @Override
                    public void set(Node node) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public void add(Node node) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Node previous() {
                        Node n = this.iter.previous();
                        --this.index;
                        return n;
                    }

                    @Override
                    public boolean hasPrevious() {
                        return this.iter.hasPrevious();
                    }

                    @Override
                    public int nextIndex() {
                        return this.index;
                    }

                    @Override
                    public int previousIndex() {
                        return this.index - 1;
                    }
                };
            }
        };
    }

    private static List<Node> castNodes(List<NodeImpl> nodes) {
        List<Node> list = nodes;
        return list;
    }

    private static List<Edge> castEdges(List<EdgeImpl> edges) {
        List<Edge> list = edges;
        return list;
    }

    @Override
    public ExtendedListIterable<Node> nodes() {
        if (this.containsHint(Hint.FAST_NODE_ITERATION)) {
            List<Node> finalNodesList;
            List<Node> nodesList = null;
            if (this.nodesCache != null) {
                nodesList = this.nodesCache.get();
            }
            if (nodesList == null) {
                nodesList = new LinkedList<Node>();
                try {
                    for (NodeImpl n : this.nodes) {
                        nodesList.add(n);
                    }
                }
                catch (OutOfMemoryError e) {
                    return this.iterableNodes(this.nodes, this.nodeCount());
                }
                this.nodesCache = new SoftReference<List<Node>>(nodesList);
            }
            if ((finalNodesList = this.nodesCache.get()) != null) {
                return new ExtendedListIterable<Node>(this.nodes.size()){

                    @Override
                    protected ListIterator<Node> listIteratorImpl() {
                        return new DelegateListIterator<Node>(finalNodesList.listIterator()){

                            @Override
                            public void remove() {
                                AbstractListGraph.this.removeNode((Node)this.last);
                                this.last = null;
                            }
                        };
                    }
                };
            }
        }
        return this.iterableNodes(this.nodes, this.nodeCount());
    }

    @Override
    public ExtendedListIterable<Node> adjacentNodes(final Node n, final Direction direction) {
        Args.notNull(new Object[]{n, direction});
        return new ExtendedListIterable<Node>(this.degree(n, direction)){

            @Override
            protected ListIterator<Node> listIteratorImpl() {
                return new ListIterator<Node>(){
                    final ListIterator<Edge> incidentEdges;
                    Node last;
                    {
                        this.incidentEdges = AbstractListGraph.this.edges(n, direction).listIterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.incidentEdges.hasNext();
                    }

                    @Override
                    public Node next() {
                        this.last = this.incidentEdges.next().opposite(n);
                        return this.last;
                    }

                    @Override
                    public boolean hasPrevious() {
                        return this.incidentEdges.hasPrevious();
                    }

                    @Override
                    public Node previous() {
                        this.last = this.incidentEdges.previous().opposite(n);
                        return this.last;
                    }

                    @Override
                    public void remove() {
                        if (this.last == null) {
                            throw new IllegalStateException();
                        }
                        AbstractListGraph.this.removeNode(this.last);
                        this.last = null;
                    }

                    @Override
                    public void set(Node n) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public void add(Node n) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public int previousIndex() {
                        return this.incidentEdges.previousIndex();
                    }

                    @Override
                    public int nextIndex() {
                        return this.incidentEdges.nextIndex();
                    }
                };
            }
        };
    }

    @Override
    public boolean removeEdge(Edge edge) {
        if (!this.containsEdge(edge)) {
            return false;
        }
        final EdgeImpl e = (EdgeImpl)edge;
        this.graphEventSupport.fire(new GraphEvent(this, GraphEvent.Type.EDGE_REMOVED, edge), new Runnable(){

            public void run() {
                NodeImpl n1 = e.n1();
                NodeImpl n2 = e.n2();
                AbstractListGraph.this.getEdgeOutRef(e).remove();
                AbstractListGraph.this.getEdgeInRef(e).remove();
                AbstractListGraph.this.removeEdgeRefs(e);
                --AbstractListGraph.this.edgeCount;
                AbstractListGraph.this.edgesCache = null;
            }
        });
        return true;
    }

    @Override
    public boolean removeNode(final Node node) {
        if (!this.containsNode(node)) {
            return false;
        }
        this.graphEventSupport.fire(new GraphEvent(this, GraphEvent.Type.NODE_REMOVED, node), new Runnable(){

            public void run() {
                NodeImpl n = (NodeImpl)node;
                for (Edge e : AbstractListGraph.this.edges(node)) {
                    AbstractListGraph.this.removeEdge(e);
                }
                AbstractListGraph.this.getNodeRef(n).remove();
                AbstractListGraph.this.removeNodeRef(n);
                AbstractListGraph.this.edgesCache = null;
                AbstractListGraph.this.nodesCache = null;
            }
        });
        return true;
    }

    @Override
    public ExtendedListIterable<Edge> edges(Node node, final Direction direction) {
        Args.notNull((Object)direction);
        final NodeImpl n = this.checkContainedAndCast(node);
        return new ExtendedListIterable<Edge>(this.degree(node, direction)){

            @Override
            protected ListIterator<Edge> listIteratorImpl() {
                return new CompoundListIterator<Edge>(direction.isOut() ? AbstractListGraph.castEdges(AbstractListGraph.this.getOutEdges(n)).listIterator() : null, direction.isIn() ? AbstractListGraph.castEdges(AbstractListGraph.this.getInEdges(n)).listIterator() : null);
            }
        };
    }

    @Override
    public ExtendedListIterable<Edge> edges(final Node n1, final Node n2, Direction direction) {
        ListIterator<Edge> outIterator;
        Args.notNull((Object)direction);
        NodeImpl node1 = this.checkContainedAndCast(n1);
        NodeImpl node2 = this.checkContainedAndCast(n2);
        Direction flip = direction.flip();
        if (this.degree(n1, direction) > this.degree(n2, flip) && n1 != n2) {
            return this.edges(n2, n1, flip);
        }
        ListIterator<Edge> listIterator = !direction.isOut() ? null : (outIterator = this.outDegree(n1) < this.inDegree(n2) ? AbstractListGraph.castEdges(this.getOutEdges(node1)).listIterator() : AbstractListGraph.castEdges(this.getInEdges(node2)).listIterator());
        final ListIterator<Edge> inIterator = !direction.isIn() ? null : (this.inDegree(n1) < this.outDegree(n2) ? AbstractListGraph.castEdges(this.getInEdges(node1)).listIterator() : AbstractListGraph.castEdges(this.getOutEdges(node2)).listIterator());
        return new ExtendedListIterable<Edge>(){

            @Override
            protected ListIterator<Edge> listIteratorImpl() {
                return new FilteringListIterator<Edge>(new CompoundListIterator(outIterator, inIterator), new Filter<Edge>(){

                    @Override
                    public boolean accept(Edge e) {
                        return e.isIncident(n1) && e.opposite(n1) == n2;
                    }
                });
            }
        };
    }

    @Override
    public boolean containsEdge(Edge edge) {
        if (edge == null) {
            return false;
        }
        try {
            EdgeImpl e = (EdgeImpl)edge;
            NodeImpl n1 = e.n1;
            return this.containsNode(n1) && this.getOutEdges(n1).ownsAccessor(this.getEdgeOutRef(e));
        }
        catch (RuntimeException ex) {
            return false;
        }
    }

    @Override
    public boolean containsNode(Node node) {
        if (node == null) {
            return false;
        }
        try {
            NodeImpl n = (NodeImpl)node;
            return this.nodes.ownsAccessor(this.getNodeRef(n));
        }
        catch (RuntimeException ex) {
            return false;
        }
    }

    @Override
    public int inDegree(Node node) {
        NodeImpl n = this.checkContainedAndCast(node);
        return this.getInEdges(n).size();
    }

    @Override
    public int outDegree(Node node) {
        NodeImpl n = this.checkContainedAndCast(node);
        return this.getOutEdges(n).size();
    }

    @Override
    public int degree(Node node) {
        NodeImpl n = this.checkContainedAndCast(node);
        return this.getOutEdges(n).size() + this.getInEdges(n).size();
    }

    @Override
    public Edge invertEdge(Edge e) {
        Args.notNull((Object)e);
        return this.updateEdge(e, e.n2(), e.n1());
    }

    @Override
    public Edge updateEdge(Edge edge, Node n1, Node n2) {
        if (!(this.containsEdge(edge) && this.containsNode(n1) && this.containsNode(n2))) {
            throw new IllegalArgumentException("All three elements (edge, n1, n2) must be contained in graph");
        }
        this.graphEventSupport.firePreEdge();
        this.removeEdge(edge);
        Edge e = this.newEdge(n1, n2, edge.getValue());
        this.graphEventSupport.firePostEdge();
        return e;
    }

    @Override
    public ExtendedListIterable<Edge> edges() {
        if (this.containsHint(Hint.FAST_EDGE_ITERATION)) {
            List<Edge> edgeList;
            List<Edge> edgesList = null;
            if (this.edgesCache != null) {
                edgesList = this.edgesCache.get();
            }
            if (edgesList == null) {
                edgesList = new LinkedList<Edge>();
                try {
                    boolean pos = false;
                    for (Edge e : this.edgesImpl()) {
                        edgesList.add(e);
                    }
                }
                catch (OutOfMemoryError e) {
                    return this.edgesImpl();
                }
                this.edgesCache = new SoftReference<List<Edge>>(edgesList);
            }
            if ((edgeList = this.edgesCache.get()) != null) {
                return new ExtendedListIterable<Edge>(edgeList.size()){

                    @Override
                    protected ListIterator<Edge> listIteratorImpl() {
                        return new DelegateListIterator<Edge>(edgeList.listIterator()){

                            @Override
                            public void remove() {
                                super.remove();
                                AbstractListGraph.this.removeEdge((Edge)this.last);
                                this.last = null;
                            }
                        };
                    }
                };
            }
        }
        return this.edgesImpl();
    }

    private ExtendedListIterable<Edge> edgesImpl() {
        return new ExtendedListIterable<Edge>(this.edgeCount()){

            @Override
            protected ListIterator<Edge> listIteratorImpl() {
                return new AbstractCompoundListIterator<Edge>(){
                    private Direction direction = null;
                    final ListIterator<Node> nodeCursor;
                    {
                        this.nodeCursor = AbstractListGraph.this.nodes().listIterator();
                    }

                    @Override
                    protected boolean hasNextIterator() {
                        if (this.direction == Direction.IN) {
                            this.nodeCursor.next();
                            this.direction = Direction.OUT;
                        }
                        return this.nodeCursor.hasNext();
                    }

                    @Override
                    protected boolean hasPreviousIterator() {
                        if (this.direction == Direction.OUT) {
                            this.nodeCursor.previous();
                            this.direction = Direction.IN;
                        }
                        return this.nodeCursor.hasPrevious();
                    }

                    @Override
                    protected ListIterator<Edge> nextIterator() {
                        this.direction = Direction.OUT;
                        return this.getEdgesOfNode(this.nodeCursor.next(), true);
                    }

                    @Override
                    protected ListIterator<Edge> previousIterator() {
                        this.direction = Direction.IN;
                        return this.getEdgesOfNode(this.nodeCursor.previous(), false);
                    }

                    private ListIterator<Edge> getEdgesOfNode(Node node, boolean start) {
                        NodeImpl n = (NodeImpl)node;
                        int index = start ? 0 : AbstractListGraph.this.outDegree(n);
                        return AbstractListGraph.castEdges(AbstractListGraph.this.getOutEdges(n)).listIterator(index);
                    }

                    @Override
                    public void remove() {
                        AbstractListGraph.this.removeEdge((Edge)this.last);
                        this.last = null;
                    }

                    @Override
                    public void add(Edge e) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public void set(Edge e) {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public Graph.OrderManager getOrderManager() {
        return new OrderManagerImpl();
    }

    private class OrderManagerImpl
    implements Graph.OrderManager {
        private OrderManagerImpl() {
        }

        public void moveNodeToFront(Node node) {
            NodeImpl n = AbstractListGraph.this.checkContainedAndCast(node);
            AbstractListGraph.this.getNodeRef(n).moveToFront();
            AbstractListGraph.this.nodesCache = null;
            AbstractListGraph.this.graphEventSupport.fire(new GraphEvent(AbstractListGraph.this, GraphEvent.Type.NODE_REORDERED, node));
        }

        public void moveNodeToBack(Node node) {
            NodeImpl n = AbstractListGraph.this.checkContainedAndCast(node);
            AbstractListGraph.this.getNodeRef(n).moveToBack();
            AbstractListGraph.this.nodesCache = null;
            AbstractListGraph.this.graphEventSupport.fire(new GraphEvent(AbstractListGraph.this, GraphEvent.Type.NODE_REORDERED, node));
        }

        public void moveNodeBefore(Node node, Node beforeWhat) {
            NodeImpl n = AbstractListGraph.this.checkContainedAndCast(node);
            NodeImpl before = AbstractListGraph.this.checkContainedAndCast(beforeWhat);
            AbstractListGraph.this.getNodeRef(n).moveBefore(AbstractListGraph.this.getNodeRef(before));
            AbstractListGraph.this.nodesCache = null;
            AbstractListGraph.this.graphEventSupport.fire(new GraphEvent(AbstractListGraph.this, GraphEvent.Type.NODE_REORDERED, node));
        }

        public void moveNodeAfter(Node node, Node afterWhat) {
            NodeImpl n = AbstractListGraph.this.checkContainedAndCast(node);
            NodeImpl after = AbstractListGraph.this.checkContainedAndCast(afterWhat);
            AbstractListGraph.this.getNodeRef(n).moveAfter(AbstractListGraph.this.getNodeRef(after));
            AbstractListGraph.this.nodesCache = null;
            AbstractListGraph.this.graphEventSupport.fire(new GraphEvent(AbstractListGraph.this, GraphEvent.Type.NODE_REORDERED, node));
        }

        public void moveEdgeToFront(Edge edge, boolean onSourceNode) {
            Accessor<EdgeImpl> ref;
            EdgeImpl e = AbstractListGraph.this.checkContainedAndCast(edge);
            if (onSourceNode) {
                NodeImpl n = e.n1();
                FastLinkedList<EdgeImpl> seq = AbstractListGraph.this.getOutEdges(n);
                ref = AbstractListGraph.this.getEdgeOutRef(e);
            } else {
                NodeImpl n = e.n2();
                FastLinkedList<EdgeImpl> seq = AbstractListGraph.this.getInEdges(n);
                ref = AbstractListGraph.this.getEdgeInRef(e);
            }
            ref.moveToFront();
            AbstractListGraph.this.edgesCache = null;
            AbstractListGraph.this.graphEventSupport.fire(new GraphEvent(AbstractListGraph.this, GraphEvent.Type.EDGE_REORDERED, edge));
        }

        public void moveEdgeToBack(Edge edge, boolean onSourceNode) {
            Accessor<EdgeImpl> ref;
            EdgeImpl e = AbstractListGraph.this.checkContainedAndCast(edge);
            if (onSourceNode) {
                NodeImpl n = e.n1();
                FastLinkedList<EdgeImpl> seq = AbstractListGraph.this.getOutEdges(n);
                ref = AbstractListGraph.this.getEdgeOutRef(e);
            } else {
                NodeImpl n = e.n2();
                FastLinkedList<EdgeImpl> seq = AbstractListGraph.this.getInEdges(n);
                ref = AbstractListGraph.this.getEdgeInRef(e);
            }
            ref.moveToBack();
            AbstractListGraph.this.edgesCache = null;
            AbstractListGraph.this.graphEventSupport.fire(new GraphEvent(AbstractListGraph.this, GraphEvent.Type.EDGE_REORDERED, edge));
        }

        public void moveEdgeBefore(Edge edge, boolean onSourceNode, Edge beforeWhat) {
            Accessor<EdgeImpl> ref2;
            Accessor<EdgeImpl> ref;
            EdgeImpl e = AbstractListGraph.this.checkContainedAndCast(edge);
            EdgeImpl before = AbstractListGraph.this.checkContainedAndCast(beforeWhat);
            if (onSourceNode) {
                NodeImpl n = e.n1();
                FastLinkedList<EdgeImpl> seq = AbstractListGraph.this.getOutEdges(n);
                ref = AbstractListGraph.this.getEdgeOutRef(e);
                ref2 = AbstractListGraph.this.getEdgeOutRef(before);
            } else {
                NodeImpl n = e.n2();
                FastLinkedList<EdgeImpl> seq = AbstractListGraph.this.getInEdges(n);
                ref = AbstractListGraph.this.getEdgeInRef(e);
                ref2 = AbstractListGraph.this.getEdgeInRef(before);
            }
            ref.moveBefore(ref2);
            AbstractListGraph.this.edgesCache = null;
            AbstractListGraph.this.graphEventSupport.fire(new GraphEvent(AbstractListGraph.this, GraphEvent.Type.EDGE_REORDERED, edge));
        }

        public void moveEdgeAfter(Edge edge, boolean onSourceNode, Edge afterWhat) {
            Accessor<EdgeImpl> ref2;
            Accessor<EdgeImpl> ref;
            EdgeImpl e = AbstractListGraph.this.checkContainedAndCast(edge);
            EdgeImpl after = AbstractListGraph.this.checkContainedAndCast(afterWhat);
            if (onSourceNode) {
                NodeImpl n = e.n1();
                FastLinkedList<EdgeImpl> seq = AbstractListGraph.this.getOutEdges(n);
                ref = AbstractListGraph.this.getEdgeOutRef(e);
                ref2 = AbstractListGraph.this.getEdgeOutRef(after);
            } else {
                NodeImpl n = e.n2();
                FastLinkedList<EdgeImpl> seq = AbstractListGraph.this.getInEdges(n);
                ref = AbstractListGraph.this.getEdgeInRef(e);
                ref2 = AbstractListGraph.this.getEdgeInRef(after);
            }
            ref.moveAfter(ref2);
            AbstractListGraph.this.edgesCache = null;
            AbstractListGraph.this.graphEventSupport.fire(new GraphEvent(AbstractListGraph.this, GraphEvent.Type.EDGE_REORDERED, edge));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class DelegateListIterator<E>
    implements ListIterator<E> {
        final ListIterator<E> delegate;
        protected E last = null;

        DelegateListIterator(ListIterator<E> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void set(E o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
        }

        @Override
        public int previousIndex() {
            return this.delegate.previousIndex();
        }

        @Override
        public E previous() {
            this.last = this.delegate.previous();
            return this.last;
        }

        @Override
        public int nextIndex() {
            return this.delegate.nextIndex();
        }

        @Override
        public E next() {
            this.last = this.delegate.next();
            return this.last;
        }

        @Override
        public boolean hasPrevious() {
            return this.delegate.hasPrevious();
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }
    }
}

