/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.concrete;

import gr.forth.ics.graph.Edge;
import gr.forth.ics.graph.Graph;
import gr.forth.ics.graph.InspectableGraph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.Tuple;
import gr.forth.ics.util.Args;
import gr.forth.ics.util.SerializableObject;
import java.util.Set;

public abstract class AbstractTuple
implements Tuple {
    private static final Object PARENT = new SerializableObject();
    private Object value;

    public AbstractTuple() {
    }

    public AbstractTuple(Object value) {
        this.setValue(value);
    }

    public Object setValue(Object value) {
        Object old = this.value;
        this.value = value;
        return old;
    }

    public Object getValue() {
        return this.value;
    }

    public void copyInto(Tuple copy) {
        Args.notNull((Object)copy);
        copy.setValue(this.getValue());
        for (Object key : this.keySet()) {
            Object value = this.get(key);
            copy.put(key, value);
        }
    }

    public boolean equalValues(Tuple that) {
        Object otherValue;
        Object value;
        if (that == null) {
            return false;
        }
        Object thisValue = this.getValue();
        Object thatValue = that.getValue();
        if (thisValue == null && thatValue != null || thisValue != null && !thisValue.equals(thatValue)) {
            return false;
        }
        Set<Object> thisKeys = this.keySet();
        Set<Object> thatKeys = that.keySet();
        if (thisKeys.size() != thatKeys.size()) {
            return false;
        }
        for (Object key : thisKeys) {
            value = this.get(key);
            otherValue = that.get(key);
            if (value == null && otherValue != null) {
                return false;
            }
            if (value == null || value.equals(otherValue)) continue;
            return false;
        }
        thatKeys.removeAll(thisKeys);
        for (Object key : thatKeys) {
            value = this.get(key);
            otherValue = that.get(key);
            if (value == null && otherValue != null) {
                return false;
            }
            if (value.equals(otherValue)) continue;
            return false;
        }
        return true;
    }

    public Node getNode(Object key) {
        return (Node)this.get(key);
    }

    public Edge getEdge(Object key) {
        return (Edge)this.get(key);
    }

    public Boolean getBoolean(Object key) {
        return (Boolean)this.get(key);
    }

    public int getInt(Object key) {
        Number number = (Number)this.get(key);
        return number.intValue();
    }

    public short getShort(Object key) {
        Number number = (Number)this.get(key);
        return number.shortValue();
    }

    public long getLong(Object key) {
        Number number = (Number)this.get(key);
        return number.longValue();
    }

    public double getDouble(Object key) {
        Number number = (Number)this.get(key);
        return number.doubleValue();
    }

    public float getFloat(Object key) {
        Number number = (Number)this.get(key);
        return number.floatValue();
    }

    public String getString(Object key) {
        return (String)this.get(key);
    }

    public Character getChar(Object key) {
        return Character.valueOf(((Character)this.get(key)).charValue());
    }

    public InspectableGraph getInspectableGraph(Object key) {
        return (InspectableGraph)this.get(key);
    }

    public Graph getGraph(Object key) {
        return (Graph)this.get(key);
    }

    public Number getNumber(Object key) {
        return (Number)this.get(key);
    }

    public Tuple getTuple(Object key) {
        return (Tuple)this.getLocally(key);
    }

    protected abstract Object getLocally(Object var1);

    protected abstract boolean hasLocally(Object var1);

    public final Object get(Object key) {
        Object value = this.getLocally(key);
        if (value == null && !this.hasLocally(key)) {
            Tuple parent = this.getParentTuple();
            if (parent == null) {
                return null;
            }
            return parent.get(key);
        }
        return value;
    }

    public final boolean has(Object key) {
        boolean exists = this.hasLocally(key);
        if (!exists) {
            Tuple parent = this.getParentTuple();
            if (parent == null) {
                return false;
            }
            return parent.has(key);
        }
        return exists;
    }

    public void setParentTuple(Tuple parent) {
        this.putWeakly(PARENT, parent);
    }

    public Tuple getParentTuple() {
        return this.getTuple(PARENT);
    }
}

