/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.concrete;

import gr.forth.ics.graph.Tuple;
import gr.forth.ics.graph.concrete.AbstractTuple;
import gr.forth.ics.util.Args;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TupleImpl
extends AbstractTuple {
    private transient Map<Object, Object> values;

    public TupleImpl() {
    }

    public TupleImpl(Object value) {
        super(value);
    }

    public TupleImpl(Map<?, ?> values) {
        Args.notNull(values);
        if (values.isEmpty()) {
            return;
        }
        this.lazyInit();
        for (Map.Entry<?, ?> entry : values.entrySet()) {
            this.values.put(entry.getKey(), entry.getValue());
        }
    }

    public TupleImpl(Tuple copy) {
        this(copy.asMap());
        this.setValue(copy.getValue());
    }

    private void lazyInit() {
        if (this.values == null) {
            this.values = new WeakHashMap<Object, Object>(1);
        }
    }

    @Override
    protected Object getLocally(Object key) {
        if (this.values == null) {
            return null;
        }
        return this.unmask(this.values.get(key));
    }

    @Override
    public Object remove(Object key) {
        if (this.values == null) {
            return null;
        }
        Object old = this.values.remove(key);
        if (this.values.size() == 0) {
            this.values = null;
        }
        return this.unmask(old);
    }

    @Override
    public Object put(Object key, Object value) {
        this.lazyInit();
        return this.unmask(this.values.put(key, this.mask(key, value)));
    }

    @Override
    public Object putWeakly(Object key, Object value) {
        this.lazyInit();
        Args.notNull("Null cannot be put weakly - use normal put instead", key);
        return this.values.put(key, value);
    }

    private StrongValue mask(Object key, Object value) {
        return new StrongValue(key, value);
    }

    private Object unmask(Object value) {
        if (value instanceof StrongValue) {
            return ((StrongValue)value).value;
        }
        return value;
    }

    @Override
    protected boolean hasLocally(Object key) {
        if (this.values == null) {
            return false;
        }
        return this.values.containsKey(key);
    }

    @Override
    public Set<Object> keySet() {
        if (this.values == null) {
            return new HashSet<Object>(1);
        }
        HashSet<Object> keys = new HashSet<Object>();
        for (Map.Entry<Object, Object> entry : this.values.entrySet()) {
            if (!(entry.getValue() instanceof StrongValue)) continue;
            keys.add(entry.getKey());
        }
        return keys;
    }

    @Override
    public Map<Object, Object> asMap() {
        return new AbstractMap<Object, Object>(){

            @Override
            public Object remove(Object key) {
                return TupleImpl.this.remove(key);
            }

            @Override
            public Object get(Object key) {
                return TupleImpl.this.get(key);
            }

            @Override
            public boolean containsKey(Object key) {
                return TupleImpl.this.has(key);
            }

            @Override
            public Object put(Object key, Object value) {
                return TupleImpl.this.put(key, value);
            }

            @Override
            public Set<Map.Entry<Object, Object>> entrySet() {
                if (TupleImpl.this.values == null) {
                    return Collections.emptySet();
                }
                final Set delegate = TupleImpl.this.values.entrySet();
                return new Set<Map.Entry<Object, Object>>(){

                    @Override
                    public boolean add(Map.Entry<Object, Object> o) {
                        Object oldValue = TupleImpl.this.get(o.getKey());
                        boolean existed = oldValue != null ? true : TupleImpl.this.has(o.getKey());
                        TupleImpl.this.put(o.getKey(), o.getValue());
                        if (oldValue != o.getValue()) {
                            return true;
                        }
                        return !existed;
                    }

                    @Override
                    public boolean addAll(Collection<? extends Map.Entry<Object, Object>> c) {
                        boolean changed = false;
                        for (Map.Entry<Object, Object> entry : c) {
                            changed |= this.add(entry);
                        }
                        return changed;
                    }

                    @Override
                    public boolean contains(Object o) {
                        return delegate.contains(o);
                    }

                    @Override
                    public boolean remove(Object o) {
                        return delegate.remove(o);
                    }

                    @Override
                    public <T> T[] toArray(T[] a) {
                        return delegate.toArray(a);
                    }

                    @Override
                    public boolean containsAll(Collection<?> c) {
                        return delegate.containsAll(c);
                    }

                    @Override
                    public boolean removeAll(Collection<?> c) {
                        return delegate.removeAll(c);
                    }

                    @Override
                    public boolean retainAll(Collection<?> c) {
                        return delegate.retainAll(c);
                    }

                    @Override
                    public void clear() {
                        delegate.clear();
                    }

                    @Override
                    public boolean isEmpty() {
                        return delegate.isEmpty();
                    }

                    @Override
                    public Iterator<Map.Entry<Object, Object>> iterator() {
                        final Iterator iDelegate = delegate.iterator();
                        return new Iterator<Map.Entry<Object, Object>>(){

                            @Override
                            public boolean hasNext() {
                                return iDelegate.hasNext();
                            }

                            @Override
                            public Map.Entry<Object, Object> next() {
                                Map.Entry e = (Map.Entry)iDelegate.next();
                                e.setValue(TupleImpl.this.unmask(e.getValue()));
                                return e;
                            }

                            @Override
                            public void remove() {
                                iDelegate.remove();
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return delegate.size();
                    }

                    @Override
                    public Object[] toArray() {
                        return delegate.toArray();
                    }
                };
            }

            @Override
            public int size() {
                if (TupleImpl.this.values == null) {
                    return 0;
                }
                return TupleImpl.this.values.size();
            }

            @Override
            public String toString() {
                if (TupleImpl.this.values == null || TupleImpl.this.values.isEmpty()) {
                    return "{}";
                }
                StringBuilder sb = new StringBuilder();
                sb.append("{");
                for (Object key : TupleImpl.this.values.keySet()) {
                    sb.append(key);
                    sb.append("=");
                    sb.append(this.get(key));
                    sb.append(", ");
                }
                sb.delete(sb.length() - 2, sb.length());
                sb.append("}");
                return sb.toString();
            }
        };
    }

    private void writeObject(ObjectOutputStream out) throws Exception {
        out.defaultWriteObject();
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        if (this.values != null) {
            map.putAll(this.values);
        }
        out.writeObject(map);
    }

    private void readObject(ObjectInputStream in) throws Exception {
        in.defaultReadObject();
        Map map = (Map)in.readObject();
        if (!map.isEmpty()) {
            this.values = new WeakHashMap<Object, Object>(map);
        }
    }

    public String toString() {
        if (this.values == null || this.values.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Object key : this.values.keySet()) {
            sb.append(key);
            sb.append("->");
            sb.append(this.get(key));
            sb.append(", ");
        }
        sb.append("value=");
        sb.append(this.getValue());
        sb.append("]");
        return sb.toString();
    }

    private final class StrongValue
    implements Serializable {
        final Object key;
        final Object value;

        StrongValue(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (!(o instanceof StrongValue)) {
                return false;
            }
            StrongValue sv = (StrongValue)o;
            return this.value.equals(sv.value) && this.key.equals(sv.key);
        }

        public int hashCode() {
            int hash = 0;
            if (this.key != null) {
                hash += this.key.hashCode();
            }
            if (this.value != null) {
                hash += this.value.hashCode();
            }
            return hash;
        }

        public String toString() {
            return "[StrongValue: " + this.value + "]";
        }
    }
}

