/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.io;

import gr.forth.ics.graph.Graph;
import gr.forth.ics.graph.InspectableGraph;
import gr.forth.ics.graph.io.Format;
import gr.forth.ics.graph.layout.Locator;
import gr.forth.ics.graph.layout.Locators;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class GraphIO {
    private GraphIO() {
    }

    public static void write(Format format, InspectableGraph graph, OutputStream out) throws IOException {
        format.writer().write(graph, Locators.emptyLocator(), out);
    }

    public static void read(Format format, Graph graph, InputStream in) throws IOException {
        format.reader().read(graph, Locators.emptyLocator(), in);
    }

    public static void write(Format format, InspectableGraph graph, File file) throws IOException {
        GraphIO.write(format, graph, Locators.emptyLocator(), file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(Format format, InspectableGraph graph, Locator locator, File file) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        try {
            format.writer().write(graph, locator, out);
        }
        finally {
            ((OutputStream)out).close();
        }
    }

    public static void read(Format format, Graph graph, File file) throws IOException {
        GraphIO.read(format, graph, Locators.emptyLocator(), file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void read(Format format, Graph graph, Locator locator, File file) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        try {
            format.reader().read(graph, locator, in);
        }
        finally {
            ((InputStream)in).close();
        }
    }
}

