/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.io.gml;

import gr.forth.ics.graph.Edge;
import gr.forth.ics.graph.FlexiGraph;
import gr.forth.ics.graph.InspectableGraph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.Tuple;
import gr.forth.ics.graph.io.GraphWriter;
import gr.forth.ics.graph.layout.GPoint;
import gr.forth.ics.graph.layout.Locator;
import gr.forth.ics.util.Args;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class GmlWriter
implements GraphWriter {
    private static final GmlWriter instance = new GmlWriter();

    protected GmlWriter() {
    }

    public static GmlWriter instance() {
        return instance;
    }

    public void write(InspectableGraph graph, Locator locator, OutputStream out) throws IOException {
        new Serializer(out, locator).write(graph);
    }

    private static class Serializer {
        private final PrintWriter out;
        private final Locator locator;
        private int identation;

        Serializer(OutputStream out, Locator locator) {
            this(new PrintWriter(out), locator);
        }

        Serializer(Writer out, Locator locator) {
            Args.notNull(out, "Writer");
            Args.notNull(locator, "Locator");
            this.out = out instanceof PrintWriter ? (PrintWriter)out : new PrintWriter(out);
            this.locator = locator;
        }

        void write(InspectableGraph g) throws IOException {
            Object idKey = new Object();
            this.out.print("Creator \"");
            this.out.print(this.getClass());
            this.out.println("\"");
            this.out.print("Version \"");
            this.out.print(FlexiGraph.version());
            this.out.println("\"");
            this.out.println("graph");
            this.open();
            this.tabs();
            this.out.println("hierarchic\t1");
            this.label(g.tuple());
            this.tabs();
            this.out.println("directed\t1");
            int id = 0;
            for (Node n : g.nodes()) {
                this.tabs();
                this.out.println("node");
                this.open();
                n.putWeakly(idKey, id);
                this.tabs();
                this.out.print("id\t");
                this.out.println(id++);
                this.label(n);
                GPoint p = this.locator.getLocation(n);
                if (p != null) {
                    this.tabs();
                    this.out.println("graphics");
                    this.open();
                    this.point(p);
                    this.close();
                }
                this.close();
            }
            for (Edge e : g.edges()) {
                int id1 = e.n1().getInt(idKey);
                int id2 = e.n2().getInt(idKey);
                this.tabs();
                this.out.println("edge");
                this.open();
                this.tabs();
                this.out.println("source\t" + id1);
                this.tabs();
                this.out.println("target\t" + id2);
                this.label(e);
                List<GPoint> bends = this.locator.getBendsSafe(e);
                if (bends.size() > 0) {
                    GPoint p1 = this.locator.getLocation(e.n1());
                    GPoint p2 = this.locator.getLocation(e.n2());
                    if (p1 != null && p2 != null) {
                        this.tabs();
                        this.out.println("graphics");
                        this.open();
                        this.tabs();
                        this.out.println("Line");
                        this.open();
                        ArrayList<GPoint> points = new ArrayList<GPoint>(bends.size() + 2);
                        points.add(p1);
                        points.addAll(bends);
                        points.add(p2);
                        for (GPoint p : points) {
                            this.tabs();
                            this.out.println("point");
                            this.open();
                            this.point(p);
                            this.close();
                        }
                        this.close();
                    }
                    this.close();
                }
                this.close();
            }
            this.close();
            this.out.flush();
        }

        private void label(Tuple tuple) {
            Object value = tuple.getValue();
            if (value == null) {
                return;
            }
            this.out.print("label\t\"");
            this.out.print(value);
            this.out.println("\"");
        }

        private void tabs() {
            for (int i = 0; i < this.identation; ++i) {
                this.out.print('\t');
            }
        }

        private void open() {
            this.tabs();
            this.out.println("[");
            ++this.identation;
        }

        private void close() {
            --this.identation;
            this.tabs();
            this.out.println("]");
        }

        private void point(GPoint p) {
            this.tabs();
            this.out.print("x\t");
            this.out.println(p.x);
            this.tabs();
            this.out.print("y\t");
            this.out.println(p.y);
        }
    }
}

