/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.layout;

import gr.forth.ics.graph.Edge;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.layout.GPoint;
import gr.forth.ics.graph.layout.Locator;
import gr.forth.ics.util.Args;
import gr.forth.ics.util.EventSupport;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLocator
implements Locator {
    protected AffineTransform affineTransform;
    protected boolean isIdentity;
    private final EventSupport<Locator.LocationListener> eventSupport = new EventSupport();

    protected abstract void flushOldPoints();

    public AbstractLocator() {
        this.setAffineTransform(new AffineTransform());
    }

    public AbstractLocator(AffineTransform affineTransform) {
        this.setAffineTransform(affineTransform);
    }

    @Override
    public void setLocation(Node node, double x, double y) {
        this.setLocation(node, new GPoint(x, y));
    }

    @Override
    public void removeLocation(Node node) {
        if (node == null) {
            return;
        }
        this.setLocation(node, null);
    }

    @Override
    public void removeBends(Edge edge) {
        this.setBends(edge, (List<GPoint>)null);
    }

    @Override
    public GPoint getBend(Edge edge) {
        List<GPoint> bends = this.getBends(edge);
        if (bends == null || bends.isEmpty()) {
            return null;
        }
        return bends.get(0);
    }

    @Override
    public void setBends(Edge edge, double[][] bends) {
        Args.notNull((Object[])bends);
        ArrayList<GPoint> bendPoints = new ArrayList<GPoint>(bends.length);
        for (double[] coords : bends) {
            Args.notNull((Object)coords);
            Args.isTrue(coords.length == 2);
            GPoint point = new GPoint(coords[0], coords[1]);
            bendPoints.add(point);
        }
        this.setBends(edge, bendPoints);
    }

    @Override
    public void setBend(Edge edge, GPoint singleBend) {
        this.setBends(edge, Collections.singletonList(singleBend));
    }

    @Override
    public List<GPoint> getBendsSafe(Edge edge) {
        List<GPoint> bends = this.getBends(edge);
        if (bends == null) {
            return Collections.EMPTY_LIST;
        }
        return bends;
    }

    @Override
    public AffineTransform getAffineTransform() {
        return this.affineTransform;
    }

    @Override
    public final void setAffineTransform(AffineTransform trans) {
        if (trans == null) {
            trans = new AffineTransform();
        }
        this.affineTransform = new AffineTransform(trans);
        this.isIdentity = trans.isIdentity();
        this.flushOldPoints();
        this.fireTransformed();
    }

    @Override
    public Locator rotate(double theta) {
        this.flushOldPoints();
        this.isIdentity = false;
        this.affineTransform.rotate(theta);
        this.fireTransformed();
        return this;
    }

    @Override
    public Locator translate(double tx, double ty) {
        this.flushOldPoints();
        this.isIdentity = false;
        this.affineTransform.translate(tx, ty);
        this.fireTransformed();
        return this;
    }

    @Override
    public Locator shear(double sx, double sy) {
        this.flushOldPoints();
        this.isIdentity = false;
        this.affineTransform.shear(sx, sy);
        this.fireTransformed();
        return this;
    }

    @Override
    public Locator scale(double sx, double sy) {
        this.flushOldPoints();
        this.isIdentity = false;
        this.affineTransform.scale(sx, sy);
        this.fireTransformed();
        return this;
    }

    @Override
    public Locator rotate(double theta, double x, double y) {
        this.flushOldPoints();
        this.isIdentity = false;
        this.affineTransform.rotate(theta, x, y);
        this.fireTransformed();
        return this;
    }

    @Override
    public void removeLocationListener(Locator.LocationListener listener) {
        this.eventSupport.removeListener(listener);
    }

    @Override
    public void addLocationListener(Locator.LocationListener listener) {
        this.eventSupport.addListener(listener);
    }

    @Override
    public List<Locator.LocationListener> getLocationListeners() {
        return this.eventSupport.getListeners();
    }

    protected void fireNodeLocation(Node node, GPoint location) {
        for (Locator.LocationListener listener : this.eventSupport.getListeners()) {
            listener.onNodeLocation(node, location);
        }
    }

    protected void fireEdgeLocation(Edge edge, List<GPoint> bends) {
        for (Locator.LocationListener listener : this.eventSupport.getListeners()) {
            listener.onEdgeLocation(edge, bends);
        }
    }

    protected void fireTransformed() {
        for (Locator.LocationListener listener : this.eventSupport.getListeners()) {
            listener.transformed();
        }
    }
}

