/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.layout;

import gr.forth.ics.graph.Edge;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.layout.AbstractLocator;
import gr.forth.ics.graph.layout.GPoint;
import gr.forth.ics.util.Args;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicLocator
extends AbstractLocator {
    protected final Object LOCATION;
    private Object CACHED = new Object();
    private final GPoint defaultLocation;

    public BasicLocator() {
        this((GPoint)null);
    }

    public BasicLocator(BasicLocator copy) {
        this.LOCATION = copy.LOCATION;
        this.CACHED = copy.CACHED;
        this.defaultLocation = copy.defaultLocation;
    }

    public BasicLocator(GPoint defaultLocation) {
        this.defaultLocation = defaultLocation;
        this.LOCATION = new Object();
    }

    public BasicLocator(AffineTransform affineTransform) {
        this(affineTransform, null);
    }

    public BasicLocator(AffineTransform affineTransform, GPoint defaultLocation) {
        super(affineTransform);
        this.defaultLocation = defaultLocation;
        this.LOCATION = new Object();
    }

    @Override
    public void removeLocation(Node node) {
        if (node == null) {
            return;
        }
        node.remove(this.LOCATION);
        node.remove(this.CACHED);
    }

    @Override
    protected void flushOldPoints() {
        this.CACHED = new Object();
    }

    @Override
    public GPoint getLocation(Node node) {
        if (!node.has(this.CACHED)) {
            GPoint initialLocation = (GPoint)node.get(this.LOCATION);
            if (initialLocation == null) {
                return this.defaultLocation;
            }
            this.setLocation(node, initialLocation);
        }
        return (GPoint)node.get(this.CACHED);
    }

    @Override
    public List<GPoint> getBends(Edge edge) {
        Args.notNull((Object)edge);
        if (!edge.has(this.CACHED)) {
            List initialBends = (List)edge.get(this.LOCATION);
            if (initialBends == null) {
                return null;
            }
            this.setBends(edge, initialBends);
        }
        return (List)edge.get(this.CACHED);
    }

    @Override
    public void setLocation(Node node, GPoint location) {
        node.putWeakly(this.LOCATION, location);
        GPoint target = this.calcTransformedPoint(location);
        node.putWeakly(this.CACHED, target);
        this.fireNodeLocation(node, target);
    }

    protected final GPoint calcTransformedPoint(GPoint location) {
        if (this.isIdentity) {
            return location;
        }
        double[] coords = new double[]{location.x, location.y};
        this.affineTransform.transform(coords, 0, coords, 0, 1);
        return new GPoint(coords[0], coords[1]);
    }

    @Override
    public void setBends(Edge edge, List<GPoint> bends) {
        Args.notNull((Object)edge);
        List<GPoint> readOnly = bends == null ? null : Collections.unmodifiableList(new ArrayList<GPoint>(bends));
        edge.putWeakly(this.LOCATION, readOnly);
        List<GPoint> cached = this.isIdentity ? readOnly : this.calcTransformedBends(readOnly);
        edge.putWeakly(this.CACHED, cached);
        this.fireEdgeLocation(edge, cached);
    }

    protected final List<GPoint> calcTransformedBends(List<GPoint> readOnly) {
        if (readOnly == null) {
            return null;
        }
        ArrayList<GPoint> list = new ArrayList<GPoint>(readOnly.size());
        for (GPoint p : readOnly) {
            list.add(this.calcTransformedPoint(p));
        }
        return Collections.unmodifiableList(list);
    }
}

