/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.layout;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class GPoint {
    public static final GPoint ZERO_POINT = new GPoint(0.0, 0.0);
    public final double x;
    public final double y;

    private GPoint() {
        this(0.0, 0.0);
    }

    public GPoint(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double distance(GPoint other) {
        return this.distance(other.x, other.y);
    }

    public double distance(double x, double y) {
        return Math.hypot(this.x - x, this.y - y);
    }

    public double dotProduct(GPoint other) {
        return this.x * other.x + this.y * other.y;
    }

    public double length() {
        return Math.hypot(this.x, this.y);
    }

    public GPoint add(GPoint other) {
        if (other == ZERO_POINT) {
            return this;
        }
        return this.add(other.x, other.y);
    }

    public GPoint add(double x, double y) {
        return new GPoint(this.x + x, this.y + y);
    }

    public GPoint subtract(GPoint other) {
        return this.subtract(other.x, other.y);
    }

    public GPoint subtract(double x, double y) {
        return new GPoint(this.x - x, this.y - y);
    }

    public boolean equals(Object o) {
        if (!(o instanceof GPoint)) {
            return false;
        }
        GPoint other = (GPoint)o;
        return this.x == other.x && this.y == other.y;
    }

    public int hashCode() {
        return (int)(Double.doubleToRawLongBits(this.x) + Double.doubleToRawLongBits(this.y));
    }

    public Point2D toPoint2D(Point2D p) {
        if (p == null) {
            return new Point2D.Double(this.x, this.y);
        }
        p.setLocation(this.x, this.y);
        return p;
    }

    public GPoint midPoint(GPoint other) {
        return this.midPoint(other.x, other.y);
    }

    public GPoint midPoint(double x, double y) {
        return new GPoint((this.x + x) / 2.0, (this.y + y) / 2.0);
    }

    public GPoint midPoint(GPoint other, double ratio) {
        return this.midPoint(other.x, other.y, ratio);
    }

    public GPoint midPoint(double x, double y, double ratio) {
        double dx = x - this.x;
        double dy = y - this.y;
        return new GPoint(this.x + ratio * dx, this.y + ratio * dy);
    }

    public static GPoint toGPoint(Point2D p) {
        return new GPoint(p.getX(), p.getY());
    }

    public GPoint mul(double k) {
        return new GPoint(this.x * k, this.y * k);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }

    public static Line2D toLine(GPoint p1, GPoint p2) {
        return new Line2D.Double(p1.x, p1.y, p2.x, p2.y);
    }
}

