/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.layout;

import java.awt.Graphics;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public abstract class Logo {
    private double rads;
    private double sin;
    private double cos;
    private double currentX;
    private double currentY;
    private boolean flying = false;

    protected Logo() {
        this.setRads(0.0);
    }

    public Logo fly() {
        this.flying = true;
        return this;
    }

    public Logo land() {
        this.flying = false;
        return this;
    }

    public Logo goTo(Point2D point) {
        return this.goTo(point.getX(), point.getY());
    }

    public Logo goTo(double x, double y) {
        this.moveTo(x, y);
        return this;
    }

    private void moveRelativeTo(double dx, double dy) {
        double x = this.currentX + dx;
        double y = this.currentY + dy;
        this.moveTo(x, y);
    }

    private void moveTo(double x, double y) {
        if (this.flying) {
            this.flyLine(this.currentX, this.currentY, x, y);
        } else {
            this.drawLine(this.currentX, this.currentY, x, y);
        }
        this.currentX = x;
        this.currentY = y;
    }

    protected abstract void drawLine(double var1, double var3, double var5, double var7);

    protected abstract void flyLine(double var1, double var3, double var5, double var7);

    public Logo go(double distance) {
        this.moveRelativeTo(distance * this.cos, distance * this.sin);
        return this;
    }

    public Logo back(double distance) {
        return this.go(-distance);
    }

    public Logo faceEast() {
        this.setRads(Math.toRadians(0.0));
        return this;
    }

    public Logo faceWest() {
        this.setRads(Math.toRadians(180.0));
        return this;
    }

    public Logo faceNorth() {
        this.setRads(Math.toRadians(90.0));
        return this;
    }

    public Logo faceSouth() {
        this.setRads(Math.toRadians(270.0));
        return this;
    }

    public Logo left(double degrees) {
        return this.right(-degrees);
    }

    public Logo right(double degrees) {
        this.setRads(this.rads + Math.toRadians(degrees));
        return this;
    }

    private void setRads(double rads) {
        this.rads = rads;
        this.sin = Math.sin(rads);
        this.cos = Math.cos(rads);
    }

    public Point2D getCurrentPosition() {
        return new Point2D.Double(this.currentX, this.currentY);
    }

    public double getOrientation() {
        return Math.toDegrees(this.rads);
    }

    public Logo orientTowards(Point2D position) {
        return this.orientTowards(position.getX(), position.getY());
    }

    public Logo orientTowards(double x, double y) {
        if (this.currentX == x && this.currentY == y) {
            return this;
        }
        double dx = x - this.currentX;
        double dy = y - this.currentY;
        this.setRads(Math.atan2(dy, dx));
        return this;
    }

    public static class Drawer
    extends Logo {
        private final Graphics g;

        public Drawer(Graphics g) {
            this.g = g;
        }

        protected void drawLine(double x1, double y1, double x2, double y2) {
            this.g.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
        }

        protected void flyLine(double x1, double y1, double x2, double y2) {
        }
    }

    public static class Shaper
    extends Logo {
        private final GeneralPath path;

        public Shaper() {
            this(1);
        }

        public Shaper(int windingRule) {
            this.path = new GeneralPath(windingRule);
            this.path.moveTo(0.0, 0.0);
        }

        protected void drawLine(double x1, double y1, double x2, double y2) {
            this.path.lineTo(x2, y2);
        }

        protected void flyLine(double x1, double y1, double x2, double y2) {
            this.path.moveTo(x2, y2);
        }

        public Shape toShape() {
            return new GeneralPath(this.path);
        }
    }
}

