/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.layout.circular;

import gr.forth.ics.graph.Direction;
import gr.forth.ics.graph.Edge;
import gr.forth.ics.graph.InspectableGraph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.algo.BucketSort;
import gr.forth.ics.graph.algo.Dfs;
import gr.forth.ics.graph.concrete.SecondaryGraph;
import gr.forth.ics.graph.layout.circular.CircularOrder;
import gr.forth.ics.graph.path.ExpansionFront;
import gr.forth.ics.graph.path.Explorer;
import gr.forth.ics.graph.path.GraphTraversal;
import gr.forth.ics.graph.path.Path;
import gr.forth.ics.graph.path.PathFilter;
import gr.forth.ics.graph.path.Traversal;
import gr.forth.ics.graph.path.Visitor;
import gr.forth.ics.graph.util.UndirectedInspectableGraph;
import java.util.Iterator;
import java.util.LinkedList;

public class Circular {
    private Node startDFS = null;

    public void setStartDFS(Node node) {
        this.startDFS = node;
    }

    public CircularOrder execute(InspectableGraph graph) {
        SecondaryGraph copy = new SecondaryGraph(graph);
        BucketSort bucketSort = new BucketSort(copy);
        Node lowestNode = null;
        lowestNode = this.startDFS == null ? bucketSort.getNodes(bucketSort.getMinDegree()).iterator().next() : this.startDFS;
        LinkedList<Edge> edgesToBeRemoved = new LinkedList<Edge>();
        while (copy.nodeCount() >= 3) {
            Node selected = bucketSort.getNodes(bucketSort.getMinDegree()).iterator().next();
            Iterator<Node> neighbors = copy.adjacentNodes(selected).iterator();
            if (neighbors.hasNext()) {
                Node n1 = neighbors.next();
                while (neighbors.hasNext()) {
                    Node n2 = neighbors.next();
                    Edge e = !copy.areAdjacent(n1, n2) ? copy.newEdge(n1, n2) : copy.anEdge(n1, n2);
                    edgesToBeRemoved.add(e);
                    n1 = n2;
                }
            }
            copy.removeNode(selected);
        }
        SecondaryGraph tree = new SecondaryGraph(graph);
        Dfs dfs = new Dfs(new UndirectedInspectableGraph(tree), lowestNode);
        dfs.execute();
        for (Edge e : graph.edges()) {
            if (dfs.isTreeEdge(e)) continue;
            tree.removeEdge(e);
        }
        Path longestPath = this.computeLongestPath(tree, lowestNode);
        LinkedList<Node> unplaced = new LinkedList<Node>();
        Object PARENT = this.recordPrevInPath(longestPath);
        for (Node n : graph.nodes()) {
            if (n.has(PARENT)) continue;
            unplaced.add(n);
        }
        while (!unplaced.isEmpty()) {
            boolean placed = false;
            Node toBePlaced = (Node)unplaced.removeFirst();
            Iterator<Node> neighbors = graph.adjacentNodes(toBePlaced).iterator();
            Node neighbor = null;
            Node nextToNeighbor = null;
            while (neighbors.hasNext()) {
                neighbor = neighbors.next();
                nextToNeighbor = neighbor.getNode(PARENT);
                if (nextToNeighbor == null || !graph.areAdjacent(toBePlaced, nextToNeighbor)) continue;
                neighbor.putWeakly(PARENT, toBePlaced);
                toBePlaced.putWeakly(PARENT, nextToNeighbor);
                placed = true;
                break;
            }
            if (placed) continue;
            Node n = nextToNeighbor == null ? longestPath.headNode() : neighbor;
            neighbor = n.getNode(PARENT);
            n.putWeakly(PARENT, toBePlaced);
            toBePlaced.putWeakly(PARENT, neighbor);
        }
        LinkedList<Node> order = new LinkedList<Node>();
        Node farthest = longestPath.headNode();
        order.add(farthest);
        boolean y = false;
        for (Node tmp = farthest.getNode(PARENT); tmp != farthest; tmp = tmp.getNode(PARENT)) {
            order.add(tmp);
        }
        return new CircularOrder(order);
    }

    private Object recordPrevInPath(Path longestPath) {
        Object KEY = new Object();
        Node last = null;
        for (Node node : longestPath.nodes()) {
            node.putWeakly(KEY, last);
            last = node;
        }
        longestPath.headNode().putWeakly(KEY, longestPath.tailNode());
        return KEY;
    }

    private Path computeLongestPath(InspectableGraph graph, Node start) {
        GraphTraversal traversal = new GraphTraversal(graph, ExpansionFront.newDFS(), PathFilter.euler());
        traversal.setExplorer(Explorer.newDefaultExplorer(Direction.EITHER));
        LongestPathVisitor visitor = new LongestPathVisitor();
        traversal.traverse(start, visitor);
        visitor = new LongestPathVisitor();
        traversal.traverse(visitor.longestPath.tailNode(), visitor);
        return visitor.longestPath;
    }

    private static class LongestPathVisitor
    implements Visitor {
        Path longestPath;

        private LongestPathVisitor() {
        }

        public Traversal visit(Path path) {
            if (this.longestPath == null) {
                this.longestPath = path;
            } else if (this.longestPath.size() < path.size()) {
                this.longestPath = path;
            }
            return Traversal.CONTINUE;
        }

        public Traversal visitRejected(Path path) {
            return Traversal.CONTINUE;
        }

        public Traversal visitAccepted(Path path) {
            return Traversal.CONTINUE;
        }
    }
}

