/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.layout.circular;

import gr.forth.ics.graph.Edge;
import gr.forth.ics.graph.Graph;
import gr.forth.ics.graph.InspectableGraph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.algo.Biconnectivity;
import gr.forth.ics.graph.algo.Clusterer;
import gr.forth.ics.graph.algo.Clusterers;
import gr.forth.ics.graph.concrete.SecondaryGraph;
import gr.forth.ics.graph.layout.GPoint;
import gr.forth.ics.graph.layout.Layout;
import gr.forth.ics.graph.layout.LayoutProcess;
import gr.forth.ics.graph.layout.Locator;
import gr.forth.ics.graph.layout.SingleStepLayoutProcess;
import gr.forth.ics.graph.layout.circular.Circular;
import gr.forth.ics.graph.layout.circular.CircularOrder;
import gr.forth.ics.graph.util.FoldingGraph;
import gr.forth.ics.graph.util.UndirectedInspectableGraph;
import gr.forth.ics.util.Args;
import gr.forth.ics.util.DVMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CircularLayout
implements Layout {
    private final GPoint center;
    private final double r;
    private final double startArc;
    private final double totalArc;
    private boolean isBiconnected;
    private Hashtable<String, Node> cutNodes = null;
    private Locator circularLocator = null;
    private CircularOrder circOrder = null;

    public CircularLayout() {
        this(GPoint.ZERO_POINT, 50.0, 0.0);
    }

    public CircularLayout(GPoint center, double r, double startArc) {
        this(center, r, startArc, Math.PI * 2);
    }

    public CircularLayout(GPoint center, double r, double startArc, double totalArc) {
        Args.notNull((Object)center);
        this.center = center;
        this.r = r;
        this.startArc = startArc;
        this.totalArc = totalArc;
    }

    private Graph createBCGraph(FoldingGraph sg, Node f) {
        Graph g = sg.viewFolder(f);
        Hashtable<String, Node> list = new Hashtable<String, Node>();
        for (Edge e : sg.edges(f)) {
            if (!sg.isSyntheticEdge(e)) continue;
            Edge re = sg.getRealEdge(e);
            Node n1 = re.n1();
            Node n2 = re.n2();
            Node m1 = null;
            Node m2 = null;
            if (this.cutNodes.containsKey(n1.getValue().toString()) && !list.containsKey(n1.getValue().toString())) {
                m1 = g.newNode(n1.getValue());
                list.put(n1.getValue().toString(), m1);
            } else if (this.cutNodes.containsKey(n1.getValue().toString()) && list.containsKey(n1.getValue().toString())) {
                m1 = (Node)list.get(n1.getValue().toString());
            }
            if (this.cutNodes.containsKey(n2.getValue().toString()) && !list.containsKey(n2.getValue().toString())) {
                m2 = g.newNode(n2.getValue());
                list.put(n2.getValue().toString(), m2);
            } else if (this.cutNodes.containsKey(n2.getValue().toString()) && list.containsKey(n2.getValue().toString())) {
                m2 = (Node)list.get(n2.getValue().toString());
            }
            if (m1 != null) {
                if (m2 != null) {
                    g.newEdge(m1, m2);
                } else {
                    g.newEdge(m1, n2);
                }
            }
            if (m2 == null) continue;
            g.newEdge(n1, m2);
        }
        return g;
    }

    @Override
    public LayoutProcess layout(final InspectableGraph graph) {
        return new SingleStepLayoutProcess(){

            protected void stepImpl(Locator locator) {
                CircularLayout.this.isBiconnected = false;
                if (graph.isEmpty()) {
                    return;
                }
                Collection clusters = CircularLayout.this.getClusters(graph);
                if (!CircularLayout.this.isBiconnected) {
                    FoldingGraph superGraph = new FoldingGraph((Graph)new SecondaryGraph(graph), false);
                    for (Collection cluster : clusters) {
                        superGraph.fold(cluster);
                    }
                    Clusterer cc = Clusterers.connectedComponents(new UndirectedInspectableGraph(superGraph));
                    LinkedList order = new LinkedList();
                    for (Collection comp : cc) {
                        order.addAll(comp);
                    }
                    Circular circular = new Circular();
                    CircularOrder circularOrder = new CircularOrder(new LinkedList<Node>());
                    LinkedList placed = new LinkedList();
                    for (Node n : order) {
                        if (!superGraph.isFolder(n)) continue;
                        Graph inner = superGraph.viewFolder(n);
                        if (inner.nodeCount() != 1) {
                            inner = CircularLayout.this.createBCGraph(superGraph, n);
                            Node startDFS = CircularLayout.this.findWhereToStartDFS(inner, graph);
                            circular.setStartDFS(startDFS);
                            CircularOrder semiorder = circular.execute(inner);
                            ArrayList<Node> list = new ArrayList<Node>();
                            List<Node> lis = semiorder.getOrder();
                            int start = lis.indexOf(startDFS);
                            List<Node> lis1 = lis.subList(0, start);
                            List<Node> lis2 = lis.subList(start, lis.size());
                            ArrayList<Node> lis3 = new ArrayList<Node>();
                            lis3.addAll(lis2);
                            for (int i = lis1.size() - 1; i >= 0; --i) {
                                Node d = lis1.get(i);
                                lis3.add(d);
                            }
                            for (Node h : lis3) {
                                if (CircularLayout.this.cutNodes.containsKey(h.getValue().toString())) continue;
                                list.add(h);
                            }
                            CircularOrder semiord = new CircularOrder(list);
                            circularOrder.append(semiord);
                            continue;
                        }
                        if (placed.contains(inner.aNode())) continue;
                        ArrayList<Node> list = new ArrayList<Node>();
                        list.add(inner.aNode());
                        circularOrder.append(new CircularOrder(list));
                    }
                    CircularLayout.this.circOrder = circularOrder;
                    CircularLayout.this.circularLocator = CircularLayout.this.circOrder.getCircleLayout(CircularLayout.this.center, CircularLayout.this.r, CircularLayout.this.startArc, CircularLayout.this.totalArc, locator);
                } else {
                    Circular circular = new Circular();
                    CircularLayout.this.circOrder = circular.execute(graph);
                    CircularLayout.this.circularLocator = CircularLayout.this.circOrder.getCircleLayout(CircularLayout.this.center, CircularLayout.this.r, CircularLayout.this.startArc, CircularLayout.this.totalArc, locator);
                }
            }
        };
    }

    private Node findWhereToStartDFS(Graph graf, InspectableGraph graph) {
        Node init = null;
        LinkedList<Node> list = new LinkedList<Node>();
        Hashtable<String, Node> hash = new Hashtable<String, Node>();
        for (Node n : graf.nodes()) {
            String name = n.getValue().toString();
            for (String s : this.cutNodes.keySet()) {
                Node c = this.cutNodes.get(s);
                if (!name.equals(s)) continue;
                list.add(n);
                hash.put(s, c);
            }
        }
        int max = 0;
        for (Node m : list) {
            Node b = (Node)hash.get(m.getValue().toString());
            max = graph.degree(b) > max ? graph.degree(b) : max;
            init = m;
        }
        if (init == null) {
            init = graf.aNode();
        }
        return init;
    }

    private Collection<Collection<Node>> getClusters(InspectableGraph g) {
        Biconnectivity bic = Biconnectivity.execute(g);
        DVMap components = DVMap.newHashMapWithArrayLists();
        for (Edge e : g.edges()) {
            ((Collection)components.get(bic.componentOf(e))).add(e);
        }
        DVMap bicon = DVMap.newHashMapWithHashSets();
        this.cutNodes = new Hashtable();
        int q = 0;
        Node[] narray = new Node[2];
        for (Collection comp : components.values()) {
            Collection clusterNodes = (Collection)bicon.get(q++);
            for (Edge ed : comp) {
                narray[0] = ed.n1();
                narray[1] = ed.n2();
                for (Node node : narray) {
                    if (!bic.isCutNode(node)) {
                        clusterNodes.add(node);
                        continue;
                    }
                    if (this.cutNodes.containsKey(node.getValue().toString())) continue;
                    this.cutNodes.put(node.getValue().toString(), node);
                }
            }
        }
        LinkedList<Collection<Node>> clusters = new LinkedList<Collection<Node>>();
        for (Collection biconCluster : bicon.values()) {
            if (biconCluster.isEmpty()) continue;
            clusters.add(biconCluster);
        }
        for (Node n : g.nodes()) {
            if (!g.isIsolated(n) && !bic.isCutNode(n)) continue;
            clusters.add(Arrays.asList(n));
        }
        this.isBiconnected = clusters.size() == 1;
        return clusters;
    }
}

