/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.layout.forces2d;

import gr.forth.ics.graph.InspectableGraph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.layout.AbstractLayoutProcess;
import gr.forth.ics.graph.layout.Locator;
import gr.forth.ics.graph.layout.forces2d.Force;
import gr.forth.ics.graph.layout.forces2d.ForceAggregator;
import gr.forth.ics.graph.layout.forces2d.ForceAggregators;
import gr.forth.ics.util.Args;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ForceLayoutProcess
extends AbstractLayoutProcess {
    private final InspectableGraph graph;
    private final List<Force> forces;

    public ForceLayoutProcess(InspectableGraph graph, List<Force> forces) {
        Args.notNull(graph, forces);
        this.graph = graph;
        this.forces = forces;
    }

    public ForceLayoutProcess(InspectableGraph graph, Force ... forces) {
        this(graph, Arrays.asList(forces));
    }

    @Override
    protected void stepImpl(Locator locator) {
        ForceAggregator forceMap = this.createForceMap(this.graph);
        this.step(this.graph, locator, forceMap);
        for (Node n : this.graph.nodes()) {
            locator.setLocation(n, locator.getLocation(n).add(forceMap.getForce(n)));
        }
    }

    protected void initProcess(InspectableGraph graph) {
    }

    protected ForceAggregator createForceMap(InspectableGraph graph) {
        Object KEY = new Object();
        for (Node n : graph.nodes()) {
            n.putWeakly(KEY, new Point2D.Double());
        }
        return ForceAggregators.simple(KEY);
    }

    protected void step(InspectableGraph graph, Locator locator, ForceAggregator forceMap) {
        for (Force f : this.forces) {
            f.apply(graph, locator, forceMap);
        }
    }
}

