/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.layout.forces2d;

import gr.forth.ics.graph.InspectableGraph;
import gr.forth.ics.graph.layout.GPoint;
import gr.forth.ics.graph.layout.Layout;
import gr.forth.ics.graph.layout.LayoutProcess;
import gr.forth.ics.graph.layout.Locator;
import gr.forth.ics.graph.layout.forces2d.Force;
import gr.forth.ics.graph.layout.forces2d.ForceAggregator;
import gr.forth.ics.graph.layout.forces2d.ForceAggregators;
import gr.forth.ics.graph.layout.forces2d.ForceLayoutProcess;
import gr.forth.ics.graph.layout.forces2d.Forces;
import java.util.Arrays;
import java.util.List;

public class FruchtermanReingoldLayout
implements Layout {
    private final double temperatureDecrease;
    private double initialTemperature;
    private final List<Force> forces;

    public FruchtermanReingoldLayout() {
        this(10.0, 40.0, 100.0, 0.01);
    }

    public FruchtermanReingoldLayout(double force, double lambda, double initialTemperature, double temperatureDecrease) {
        this.forces = Arrays.asList(new Forces.NodeRepulsion(force), new Forces.Gravity(GPoint.ZERO_POINT, 0.001), new Forces.FRSpring(lambda));
        this.initialTemperature = initialTemperature;
        this.temperatureDecrease = temperatureDecrease;
    }

    public LayoutProcess layout(InspectableGraph graph) {
        return new ForceLayoutProcess(graph, this.forces){
            double temperature;
            {
                this.temperature = FruchtermanReingoldLayout.this.initialTemperature;
            }

            public boolean isDone() {
                return this.temperature < 1.0;
            }

            protected void step(InspectableGraph graph, Locator locator, ForceAggregator forceMap) {
                super.step(graph, locator, forceMap);
                this.temperature *= 1.0 - FruchtermanReingoldLayout.this.temperatureDecrease;
            }

            protected ForceAggregator createForceMap(InspectableGraph graph) {
                return ForceAggregators.temperature(super.createForceMap(graph), this.temperature);
            }
        };
    }
}

