/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.metrics;

import gr.forth.ics.graph.Direction;
import gr.forth.ics.graph.InspectableGraph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.metrics.NodeMetric;
import gr.forth.ics.graph.metrics.SimpleNodeMetric;
import gr.forth.ics.util.Args;
import java.util.List;

public class ClusteringMetrics {
    private final SimpleNodeMetric nodeClustering;
    private final double graphClustering;

    private ClusteringMetrics(InspectableGraph graph, boolean isDirected) {
        Args.notNull((Object)graph);
        Object cc = new Object();
        for (Node n : graph.nodes()) {
            n.putWeakly(cc, 0.0);
        }
        double temporaryGraphClustering = 0.0;
        Direction dir = isDirected ? Direction.OUT : Direction.EITHER;
        for (Node n : graph.nodes()) {
            List neighbors = graph.adjacentNodes(n, dir).drainToList();
            int size = neighbors.size();
            if (size <= 1) continue;
            double a = 0.0;
            for (int x = 0; x < size - 1; ++x) {
                Node n1 = (Node)neighbors.get(x);
                for (int y = x + 1; y < size; ++y) {
                    Node n2 = (Node)neighbors.get(y);
                    if (!graph.areAdjacent(n1, n2)) continue;
                    a += 1.0;
                }
            }
            a *= isDirected ? 1.0 : 2.0;
            n.putWeakly(cc, a /= (double)(size * (size - 1)));
        }
        this.nodeClustering = new SimpleNodeMetric(cc);
        for (Node n : graph.nodes()) {
            temporaryGraphClustering += n.getDouble(cc);
        }
        this.graphClustering = temporaryGraphClustering /= (double)graph.nodeCount();
    }

    public static ClusteringMetrics execute(InspectableGraph graph, boolean isDirected) {
        return new ClusteringMetrics(graph, isDirected);
    }

    public double getGraphClustering() {
        return this.graphClustering;
    }

    public NodeMetric getNodeClustering() {
        return this.nodeClustering;
    }
}

