/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.path;

import gr.forth.ics.graph.Edge;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.path.AbstractPath;
import gr.forth.ics.graph.path.Path;
import gr.forth.ics.graph.path.Paths;
import gr.forth.ics.util.CompoundIterator;
import gr.forth.ics.util.ExtendedIterable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultPath
extends AbstractPath {
    private final Node head;
    private final Node tail;
    private final Path left;
    private final Path right;
    private final int size;

    private DefaultPath(Path left, Path right) {
        if (left.tailNode() != right.headNode()) {
            throw new IllegalArgumentException("Paths: " + left + ", " + right + " are not consequtive.");
        }
        this.left = left;
        this.right = right;
        this.head = left.headNode();
        this.tail = right.tailNode();
        this.size = left.size() + right.size();
    }

    @Override
    public Node headNode() {
        return this.head;
    }

    @Override
    public Node tailNode() {
        return this.tail;
    }

    @Override
    public Edge headEdge() {
        if (this.left.edgeCount() > 0) {
            return this.left.headEdge();
        }
        return this.right.headEdge();
    }

    @Override
    public Edge tailEdge() {
        if (this.right.edgeCount() == 0) {
            return this.left.tailEdge();
        }
        return this.right.tailEdge();
    }

    @Override
    public ExtendedIterable<Path> steps() {
        return new ExtendedIterable<Path>(new Iterable<Path>(){

            @Override
            public Iterator<Path> iterator() {
                return new CompoundIterator<Path>(DefaultPath.this.left.steps().iterator(), DefaultPath.this.right.steps().iterator());
            }
        });
    }

    @Override
    public Path append(Path other) {
        return DefaultPath.newPath(this, other);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Path getStep(int index) {
        if (index < this.left.edgeCount()) {
            return this.left.getStep(index);
        }
        return this.right.getStep(index - this.left.edgeCount());
    }

    @Override
    public Node getNode(int index) {
        if (index < this.left.nodeCount()) {
            return this.left.getNode(index);
        }
        return this.right.getNode(index - this.left.edgeCount());
    }

    @Override
    public Edge getEdge(int index) {
        if (index < this.left.edgeCount()) {
            return this.left.getEdge(index);
        }
        return this.right.getEdge(index - this.left.edgeCount());
    }

    @Override
    public Path headPath(int steps) {
        if (steps == this.edgeCount()) {
            return this;
        }
        if (steps <= this.left.edgeCount()) {
            return this.left.headPath(steps);
        }
        return DefaultPath.newPath(this.left, this.right.headPath(steps - this.left.edgeCount()));
    }

    @Override
    public Path tailPath(int steps) {
        if (steps == this.edgeCount()) {
            return this;
        }
        if (steps <= this.right.edgeCount()) {
            return this.right.tailPath(steps);
        }
        return DefaultPath.newPath(this.left.tailPath(steps - this.right.edgeCount()), this.right);
    }

    @Override
    public Path slice(int start, int end) {
        if (end <= this.left.edgeCount()) {
            return this.left.slice(start, end);
        }
        if (start >= this.left.edgeCount()) {
            return this.right.slice(start - this.left.edgeCount(), end - this.left.edgeCount());
        }
        if (start == 0 && end == this.nodeCount()) {
            return this;
        }
        return DefaultPath.newPath(this.left.tailPath(this.left.edgeCount() - start), this.right.headPath(end - this.left.edgeCount()));
    }

    @Override
    public Path reverse() {
        List<Path> list = this.steps().drainToList();
        Collections.reverse(list);
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, list.get(i).reverse());
        }
        return Paths.newPath(list);
    }

    static Path newPath(Path left, Path right) {
        if (right.headNode() != left.tailNode()) {
            throw new IllegalArgumentException("Paths: " + left + " and " + right + " are not consequtive");
        }
        if (left.edgeCount() == 0) {
            return right;
        }
        if (right.edgeCount() == 0) {
            return left;
        }
        return new DefaultPath(left, right);
    }
}

